<?php
$oswc_front = array(
	'sidebar_unique' => true,
	'sidebar_show' => true,
	'featured_show' => true,
	'featured_size' => 'large',
	'featured_duration' => 3,
	'featured_num' => 4,
	'featured_tag' => 'featured',
	'spotlight_show' => true,
	'spotlight_duration' => 3,
	'spotlight_scroll' => true,
	'spotlight_header' => 'In The Spotlight',
	'spotlight_num' => 4,
	'spotlight_type' => 'tag',
	'spotlight_tags' => 'spotlight',
	'tabs_show' => true,
	'tabs_cats' => 'Test Category, Another Category, Uncategorized',
	'tabs_type' => 'category',
	'tabs_numberpanel' => 6,
	'latestposts_show' => false,
	'latestposts_header' => 'Latest Posts',
	'latestposts_num' => 4,
	'trending_show' => true,
	'trending_header' => 'Newly Reviewed',
	'trending_num' => 8,
	'trending_type' => 'tag',
	'trending_tags' => 'slider',
	'categorypanels_show' => true,
	'categorypanels_cats_headers' => '',
	'categorypanels_numberpanel' => 5,
	'categorypanel_largepost' => true,
	'categorypanels_type' => 'category',
	'categorypanels_cats' => '',
	'front_latest_layout' => 'A',
	'front_latest_excerpt_enabled' => true,
	'front_latest_more_enabled' => true,
	'front_latest_category' => true,
);

$oswc_single = array(
	'post_sidebar_unique' => false,
	'post_sidebar_hide' => false,
	'post_featured_image_video_show' => false,
	'post_featured_image_hide' => false,
	'post_tags_hide' => false,
	'post_related_hide' => false,
	'post_related_header_text' => 'Related: ',
	'post_related_number' => 6,
	'post_trending_hide' => true,
	'review_sidebar_unique' => false,
	'review_featured_image_video_show' => false,
	'review_tags_hide' => false,
	'review_related_hide' => false,
	'review_related_header_text' => 'Related: ',
	'review_trending_hide' => true,
	'sharebox_hide' => false,
	'authorbox_hide' => false,
	'twitter_show' => true,
	'facebook_show' => true,
	'digg_show' => false,
	'stumbleupon_show' => false,
	'plusone_show' => true,
	'yahoo_show' => false,
	'pinterest_show' => true,
	'tumblr_show' => false,
	'email_show' => true,	
);

$oswc_other = array(
	'archive_layout' => 'A',
	'archive_latest_hide' => false,
	'archive_dontmiss_hide' => false,
	'archive_sideber_show' => true,
	'archive_unique_sideber' => false,
	'archive_header' => '',
	'archive_meta_enabled' => true,
	'archive_excerpt_enabled' => true,	
	'archive_trending_enabled' => false,
	'search_latest_hide' => true,
	'search_dontmiss_hide' => true,
	'search_unique_sideber' => false,
	'search_meta_enabled' => true,
	'search_excerpt_enabled' => true,
	'search_more_enabled' => true,
	'search_trending_enabled' => false,
	'author_latest_hide' => true,
	'author_dontmiss_hide' => true,
	'author_sidebar_unique' => false,
	'author_header' => 'Contributors',
	'author_exclude' => '',
	'author_trending_enabled' => true,
	'directory_sidebar_enabled' => true,
	'directory_exclude_type' => '',
	'404_latest_hide' => false,
	'404_dontmiss_hide' => false,
	'404_sidebar_unique' => false,
	'404_trending_enabled' => false,
	'page_sidebar_unique' => false,
	'page_trending_hide' => true,
	'full_width_trending_hide' => true,
	'review_sidebar_unique' => false,
	'review_num' => 6,	
);

$oswc_ads = array(
	'header_ad_hide' => false,
	'header_ad' => '<a href="http://themeforest.net/?ref=IndustrialThemes"><img src="http://demos.brianmcculloh.com/continuum/files/2011/03/ad-top.png" /></a>',	
	'menu_ad_hide' => true,
	'menu_ad' => '<a href="http://themeforest.net/?ref=IndustrialThemes"><img alt="Advertisement" src="http://demos.brianmcculloh.com/continuum/files/2011/03/ad-wide-1.png"></a>',
		'latest_ad_hide' => true,
	'latest_ad' => '<a href="http://themeforest.net/?ref=IndustrialThemes"><img alt="Advertisement" src="http://demos.brianmcculloh.com/continuum/files/2011/03/ad-wide-1.png"></a>',
	'footer_ad_hide' => true,
	'footer_ad' => '<a href="http://themeforest.net/?ref=IndustrialThemes"><img alt="Advertisement" src="http://demos.brianmcculloh.com/continuum/files/2011/03/ad-wide-1.png"></a>',		
	'single_text_ad_hide' => true,	
	'single_text_ad' => '<a href="http://themeforest.net/?ref=IndustrialThemes"><img src="http://demos.brianmcculloh.com/swagger/files/2011/10/sample-ad.png"></a>',
	'single_comments_ad_hide' => true,
	'single_comments_ad' => '<a href="http://themeforest.net/?ref=IndustrialThemes"><img src="http://demos.brianmcculloh.com/swagger/files/2011/10/sample-ad.png"></a>',
	'review_overview_ad_hide' => true,
	'review_overview_ad' => '<a href="http://themeforest.net/?ref=IndustrialThemes"><img src="http://demos.brianmcculloh.com/swagger/files/2011/10/sample-ad.png"></a>',
	'review_text_ad_hide' => true,
	'review_text_ad' => '<a href="http://themeforest.net/?ref=IndustrialThemes"><img src="http://demos.brianmcculloh.com/swagger/files/2011/10/sample-ad.png"></a>',
	'review_comments_ad_hide' => true,
	'review_comments_ad' => '<a href="http://themeforest.net/?ref=IndustrialThemes"><img src="http://demos.brianmcculloh.com/swagger/files/2011/10/sample-ad.png"></a>',
	'featured_ad_hide' => true,
	'featured_ad' => '<a href="http://themeforest.net/?ref=IndustrialThemes"><img src="http://demos.brianmcculloh.com/swagger/files/2011/10/sample-ad.png"></a>',
	'spotlight_ad_hide' => true,
	'spotlight_ad' => '<a href="http://themeforest.net/?ref=IndustrialThemes"><img src="http://demos.brianmcculloh.com/swagger/files/2011/10/sample-ad.png"></a>',
	'tabs_ad_hide' => true,
	'tabs_ad' => '<a href="http://themeforest.net/?ref=IndustrialThemes"><img src="http://demos.brianmcculloh.com/swagger/files/2011/10/sample-ad.png"></a>',	
	'trending_ad_hide' => true,
	'trending_ad' => '<a href="http://themeforest.net/?ref=IndustrialThemes"><img src="http://demos.brianmcculloh.com/swagger/files/2011/10/sample-ad.png"></a>',	
	'categorypanels_ad_hide' => true,
	'categorypanels_ad' => '<a href="http://themeforest.net/?ref=IndustrialThemes"><img src="http://demos.brianmcculloh.com/swagger/files/2011/10/sample-ad.png"></a>',
		
	'ad_num' => 10,
	'ad_increment' => 5,
	'ad_offset' => 2,
	'ad_shuffle' => true,
	'ad1' => '<a href="http://themeforest.net/?ref=IndustrialThemes"><img alt="Advertisement" src="http://demos.brianmcculloh.com/continuum/files/2011/02/ad-feed-1.png" /></a>',
	'ad2' => '<a href="http://themeforest.net/?ref=IndustrialThemes"><img alt="Advertisement" src="http://envato.s3.amazonaws.com/referrer_adverts/tutorials_300x250_v1.gif" /></a>',
	'ad3' => '<a href="http://themeforest.net/?ref=IndustrialThemes"><img alt="Advertisement" src="http://envato.s3.amazonaws.com/referrer_adverts/3d_300x250_v1.gif" /></a>',
	'ad4' => '<a href="http://themeforest.net/?ref=IndustrialThemes"><img alt="Advertisement" src="http://envato.s3.amazonaws.com/referrer_adverts/gr_300x250_v2.gif" /></a>',
	'ad5' => '<a href="http://themeforest.net/?ref=IndustrialThemes"><img alt="Advertisement" src="http://envato.s3.amazonaws.com/referrer_adverts/tf_300x250_v5.gif" /></a>',
	'ad6' => '<a href="http://themeforest.net/?ref=IndustrialThemes"><img alt="Advertisement" src="http://envato.s3.amazonaws.com/referrer_adverts/vh_300x250_v5.gif" /></a>',
	'ad7' => '<a href="http://themeforest.net/?ref=IndustrialThemes"><img alt="Advertisement" src="http://envato.s3.amazonaws.com/referrer_adverts/ad_300x250_v5.gif" /></a>',
	'ad8' => '<a href="http://themeforest.net/?ref=IndustrialThemes"><img alt="Advertisement" src="http://envato.s3.amazonaws.com/referrer_adverts/cc_300x250_v1.gif" /></a>',
	'ad9' => '<a href="http://themeforest.net/?ref=IndustrialThemes"><img alt="Advertisement"  src="http://miscfiles.s3.amazonaws.com/referrer_adverts/pd_300x250_v1.gif" /></a>',
	'ad10' => '<a href="http://themeforest.net/?ref=IndustrialThemes"><img alt="Advertisement" src="http://envato.s3.amazonaws.com/referrer_adverts/tf_300x250_v2.gif" /></a>',		
);

$oswc_bp = array(
	'bp_sidebar_unique' => false,
	'bp_activity_sidebar_unique' => false,
	'bp_members_sidebar_unique' => false,
	'bp_groups_sidebar_unique' => false,
	'bp_forums_sidebar_unique' => false,
	'bp_blogs_sidebar_unique' => false,
	'bp_registration_sidebar_unique' => false,
);

$oswc_misc = array(
	'background' => '',
	'background_fixed' => false,
	'logo' => get_template_directory_uri()."/images/logo-main.png",
	'logo_iphone' => '',
	'logo_ipad' => '',
	'skin' => 'light',
	'color_scheme' => 'C32C0D',
	'logo_bar_image' => '',
	'hide_logo_bar_bg' => false,
	'search_show' => true,
	'top_widget_show' => true,
	'random_show' => true,
	'sub_menu_hide' => false,
	'footer_menu_hide' => false,
	'colorbox' => true,
	'demo' => false,
	'responsive_tablet' => true,
	'responsive_phone' => true,
	
	'dontmiss_hide' => false,	
	'dontmiss_header' => "Don't Miss",
	'dontmiss_scroll' => true,
	'dontmiss_tag' => "dont-miss",
	'dontmiss_num' => 5,
	'dontmiss_type' => 'tag',
	'dontmiss_email_header' => "Get Our Newsletter",
	'dontmiss_widget_type' => 'Signup',
	
	'latest_hide' => false,	
	'latest_tag' => 'Latest',
	'latest_num' => 6,
	'latest_type' => 'tag',
		
	'signoff_text1' => "Did you enjoy this article? If so, we'd love to hear your thoughts in the comments below. It would be great if you subscribed to our RSS feed or signed up for email updates to get more goodness. There's lots more where this came from!",
	'signoff_text2' => "Here is signoff text 2. You can specify a different set of text and then apply that to posts. Suspendisse potenti. Integer adipiscing sodales eros a facilisis. Etiam eros lectus, fringilla ac porta non, tincidunt ultrices augue. Pellentesque tempus elementum leo, a pellentesque tellus sodales id. Ut auctor congue accumsan.",
	'signoff_text3' => "Here is signoff text 3. Donec tempus pretium aliquam. Aenean posuere, dui sed lacinia commodo, quam leo viverra odio, et congue sem nibh et ipsum. Suspendisse potenti. Integer adipiscing sodales eros a facilisis. Etiam eros lectus, fringilla ac porta non, tincidunt ultrices augue. Pellentesque tempus elementum leo, a pellentesque tellus sodales id. Ut auctor congue accumsan.",
	
	'twitter_name' => 'IndustrialThemes',
	'facebook_url' => 'http://www.facebook.com/pages/Outer-Spice-Web-Company/144008024120',
	'rss_feed' => '',
	'feedburner' => '',
	'flickr_name' => '44272373@N02',
	'google_analytics' => '',
);

if ( is_admin() ) : // Load only if we are viewing an admin page

function oswc_register_settings() {
	// Register settings and call sanitation functions
	register_setting( 'oswc_theme_description', 'oswc_description', 'oswc_validate_description' );
	register_setting( 'oswc_theme_front', 'oswc_front', 'oswc_validate_front' );
	register_setting( 'oswc_theme_single', 'oswc_single', 'oswc_validate_single' );
	register_setting( 'oswc_theme_other', 'oswc_other', 'oswc_validate_other' );
	register_setting( 'oswc_theme_ads', 'oswc_ads', 'oswc_validate_ads' );
	register_setting( 'oswc_theme_bp', 'oswc_bp', 'oswc_validate_bp' );
	register_setting( 'oswc_theme_misc', 'oswc_misc', 'oswc_validate_misc' );
	//get js and style
	$file_dir=get_template_directory_uri();
	wp_enqueue_style("functions", $file_dir."/functions/functions.css", false, "1.0", "all");
	wp_enqueue_script("rm_script", $file_dir."/functions/rm_script.js", false, "1.0");
}

add_action( 'admin_init', 'oswc_register_settings' );

function oswc_theme_options() {
	// Add theme options page to the addmin menu
	add_theme_page( 'Theme Options', 'Theme Options', 'edit_theme_options', 'theme_options', 'oswc_theme_home_page' );
}

add_action( 'admin_menu', 'oswc_theme_options' );

function mytheme_admin_tabs( $current = 'description' ) { 

	echo '<div class="wrap">';
	
	screen_icon(); echo "<h2>" . __( 'Theme Options','made' ) . "</h2>";

    $tabs = array( 'description' => __( 'Getting Started', 'made' ), 'front' => __( 'Front Page', 'made' ), 'single' => __( 'Single Posts', 'made' ), 'other' => __( 'Other Pages', 'made' ), 'ads' => __( 'Ads', 'made' ), 'bp' => __( 'BuddyPress', 'made' ), 'misc' => __( 'Miscellaneous', 'made' ) ); 
    $links = array(); 
    foreach( $tabs as $tab => $name ) : 
        if ( $tab == $current ) : 
            $links[] = "<a class='nav-tab nav-tab-active' href='?page=theme_options&tab=$tab'>$name</a>"; 
        else : 
            $links[] = "<a class='nav-tab' href='?page=theme_options&tab=$tab'>$name</a>"; 
        endif; 
    endforeach; 
    echo '<h3>'; 
    foreach ( $links as $link ) 
        echo $link; 
    echo '</h3>'; 
}

// Function to generate options page
function oswc_theme_home_page() {
	global $pagenow;
	
	if ( $pagenow == 'themes.php' && $_GET['page'] == 'theme_options' ) : 
    if ( isset ( $_GET['tab'] ) ) : 
        $tab = $_GET['tab']; 
    else: 
        $tab = 'description'; 
    endif; 
	
	mytheme_admin_tabs($tab);
	
    switch ( $tab ) : 
		case 'description' :
			theme_description_options();
			break;
        case 'front' : 
            theme_front_options(); 
            break; 
        case 'single' : 
            theme_single_options(); 
            break; 
		case 'other' : 
            theme_other_options(); 
            break; 
		case 'ads' : 
            theme_ads_options(); 
            break; 
		case 'bp' : 
            theme_bp_options(); 
            break; 
		case 'misc' : 
            theme_misc_options(); 
            break; 
    endswitch; 
	endif;
}

// Function to generate options page
function theme_description_options() {
	global $oswc_description; ?>	
    
    	<div style="padding:0px 10px; width:850px;">
        
        	<h3><?php _e( 'Introduction &amp; How To Get Help', 'made' ); ?></h3>
            
            <p>
				<?php _e( 'The Theme Options page is separated into tabs to make it easier to manage the abundance of options. If you want to skip all this and just get your site working, you should be able to get by with changing a couple of the options on the Miscellaneous tab, and you are in business. The rest of these settings exist to give you the option of customizing your website to whatever level you want. Some of the tabs are further categorized by toggle bars for your convenience. Just click the toggle bar title to expand the section and manage the options, and click it again to collapse it. The options are layed out in an intuitive, easy-to-use format that makes it easy for you to find the setting you want to adjust. There is a short description next to each option, so if something seems confusing at first, just look at the description and you will probably figure it out. If at any time you do get stuck and cannot figure out how to make the theme do what you want it to do, you have four options at your disposal:', 'made' ); ?>
                
                <ol>
                	<li><?php _e( 'Refer to the', 'made' ); ?> <a href="<?php echo get_template_directory_uri(); ?>/documentation/" target="_blank"><?php _e( 'help documentation', 'made' ); ?></a> <?php _e( 'that is inside of the theme folder folder, as it contains further detailed information on using the theme.', 'made' ); ?></li>
                    <li><?php _e( 'Refer to the FAQ found in the Live Demo.', 'made' ); ?></li>
                    <li><?php _e( 'Search for help on the support forum, or post a new topic with your question:', 'made'); ?> <a href="http://support.industrialthemes.com/viewforum.php?f=6"><?php _e ('Support Forum','made'); ?></a></li>
                    <li><?php _e( 'Contact the author of the theme via a ', 'made' ); ?><a href="http://themeforest.net/user/IndustrialThemes"><?php _e( 'Theme Forest message', 'made' ); ?></a>.
                </ol>
                
                <?php _e( 'We know what it is like to be frustrated while trying to use a theme, and we want you to know that we are here to help. We want you to fully enjoy all the benefits of this theme that we took months to build!', 'made' ); ?>                
            </p>
            
            <h3><?php _e( 'Explanation of the Theme Options Tabs', 'made' ); ?></h3>
            
            <p>
            
            <b><?php _e( 'FRONT PAGE tab', 'made' ); ?></b> - <?php _e( 'these settings let you adjust the layout and style of the front page of your site. This tab is split into the main components that make up the front page, including the Featured Slider, the Spotlight Slider, the Trending Slider, the Category panels, and the Sidebar. Whether you are using "Your latest posts" as the "Front page displays" option on the Settings >> Reading Settings page, or you have selected a specific page as your front page, this is where you manage the settings. Keep in mind, this tab deals with the layout of the elements specific to the front page. If you are wondering about things like the Latest slider, the background, logo, colors, ad placement, etc., you will find those on other tabs, such as the Ads tab or the Miscellaneous tab, since they are elements that appear on more than just the front page.', 'made' ); ?>
            
            </p>    
            
            <p>
            
            <b><?php _e( 'SINGLE POSTS tab', 'made' ); ?></b> - <?php _e( 'these settings apply to all single post views, including regular posts and reviews. This tab contains settings organized by single post options (regular WordPress posts), single review options (your custom created post types), and post + review options (settings that apply to both regular post and review pages).', 'made' ); ?>
            
            </p>

            <p>
            
            <b><?php _e( 'OTHER PAGES tab', 'made' ); ?></b> - <?php _e( 'these settings apply to all pages except the front page and single post/review pages, including such pages as Archives, Search Results, and the Author listing page, among others. This tab is split into the following four sub-sections:', 'made' ); ?>
            
            	<ol>
                	<li><?php _e( 'Archive Pages - when you click a link in your sidebar calendar widget, or you are viewing all of the posts from a specific tag/category/author, for instance, you are viewing an "archive page"', 'made' ); ?></li>
                    <li><?php _e( 'Search Results - when you enter keywords in the search box and hit enter, the resulting page is the "search results" page.', 'made' ); ?></li>
                    <li><?php _e( 'Authors Page - this is setup by creating a page and assigning the Authors Page template.', 'made' ); ?></li>
                    <li><?php _e( 'More Page Options - this includes the rest of the pages, including 404 pages, WordPress created pages, the full-width page template, etc.', 'made' ); ?></li>
                </ol>
            
            </p>   
            
            <p>
            
            <b><?php _e( 'ADS tab', 'made' ); ?></b> - <?php _e( 'This theme has a built-in advertising framework that lets you specify the ads that display throughout your pages. You can display different ads on different types of pages, which are divided out between the various toggle panels on the Ads tab. This theme is even able to inject ads into the various posts loops and lets you specify the frequency, amount, off-sets, and whether or not to shuffle the ads that are within the post loops. This tab is split into the following three sub-sections:', 'made' ); ?>
            
            	<ol>
                	<li><?php _e( 'Ads that appear on all pages - this includes ads such as header, menu, and footer ads, which will be seen on all pages regardless of post type.', 'made' ); ?></li>
                    <li><?php _e( 'Ads that appear in the loop - this includes all ads that appear within the post loops, regardless of post type. ', 'made' ); ?></li>
                    <li><?php _e( 'Ads that appear on single pages - split into three groups (front page, single posts, and single reviews), this includes ads that appear only when viewing the front page or a single post/review.', 'made' ); ?></li>
                </ol>
            
            </p>   
            
            <p>
            
            <b><?php _e( 'BUDDYPRESS tab', 'made' ); ?></b> - <?php _e( 'These settings apply to the BuddyPress section of the theme. This tab was added in Made version 2.0 and contains settings that pertain to how the existing theme interacts with BuddyPress. The rest of the BuddyPress settings are in the various BuddyPress plugin options pages.', 'made' ); ?>
           
            </p> 
            
            <p>
            
            <b><?php _e( 'MISCELLANEOUS tab', 'made' ); ?></b> - <?php _e( 'there are some elements that apply to all of your pages (or multiple pages), such as the site background, logo, Latest Slider, Google Analytics code, and more. All of these global settings are found on the Miscellanous tab.', 'made' ); ?>
            
            </p>
            
            <br />
	
    		<div class="special-text"><?php _e( '*You can override settings denoted in blue on individual posts &amp; pages using custom fields.', 'made' ); ?></div>
            
            <h3><?php _e( 'What About Reviews?', 'made' ); ?></h3>
            
            <p>
            
            <?php _e( 'The control panel for creating and managing your custom review types is separated into a different settings page. It is located at Appearance >> Review Options in the menu to the left. Note that there are a few general review settings within these Theme Options tabs, but all of the information specific to your review types is managed in the Review Options control panel.', 'made' ); ?>
            
            </p>   
        
        </div>
    
	</div>
    
<?php }

// Function to generate options page
function theme_front_options() {
	global $oswc_front;

	if ( ! isset( $_REQUEST['updated'] ) )
		$_REQUEST['updated'] = false; // This checks whether the form has just been submitted. ?>	

	<?php if ( false !== $_REQUEST['updated'] ) : ?>
	<div class="updated fade"><p><strong><?php _e( 'Options saved', 'made' ); ?></strong></p></div>
	<?php endif; // If the form has just been submitted, this shows the notification ?>

	<form method="post" action="options.php">

	<?php $settings = get_option( 'oswc_front', $oswc_front ); ?>
	
	<?php settings_fields( 'oswc_theme_front' );
	/* This function outputs some hidden fields required by the form,
	including a nonce, a unique number used to ensure the form has been submitted from the admin page
	and not somewhere else, very important for security */ ?>

	<table class="form-table">
    
    <tr valign="top">
	<td colspan="2">
	<h3><?php _e( 'Display Sidebar', 'made' ); ?></h3>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><?php _e( 'Display Page Sidebar', 'made' ); ?></th>
	<td>
	<input type="checkbox" id="sidebar_show" name="oswc_front[sidebar_show]" value="1" <?php checked( true, $settings['sidebar_show'] ); ?> />
    <label for="sidebar_show"><?php _e( 'Display the page sidebar. If this option is enabled, the Frontpage Sidebar widget panel will extent all the way down the page. If this option is disabled, the Frontpage Sidebar widget panel will only display next to the featured slider and the rest of the page will be full-width.', 'made' ); ?></label>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><?php _e( 'Unique Sidebar', 'made' ); ?></th>
	<td>
	<input type="checkbox" id="sidebar_unique" name="oswc_front[sidebar_unique]" value="1" <?php checked( true, $settings['sidebar_unique'] ); ?> />
    <label for="sidebar_unique"><?php _e( 'Display widgets from the Frontpage Sidebar widget panel instead of the Default Sidebar widget panel.', 'made' ); ?></label>
	</td>
	</tr>
    
    <tr valign="top">
	<td colspan="2">
	<h3><?php _e( 'Featured Slider', 'made' ); ?></h3>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><?php _e( 'Display Featured Slider', 'made' ); ?></th>
	<td>
	<input type="checkbox" id="featured_show" name="oswc_front[featured_show]" value="1" <?php checked( true, $settings['featured_show'] ); ?> />
    <label for="featured_show"><?php _e( 'Display the Featured slider area (Nivo slider)', 'made' ); ?></label>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><?php _e( 'Featured Slider Size', 'made' ); ?></th>
    <td>
    <input type="radio" id="featured_size_small" name="oswc_front[featured_size]" value="small" <?php checked( $settings['featured_size'], 'small' ); ?> />
    <label for="featured_size_small"><?php _e('Small','made'); ?></label>
    &nbsp;&nbsp;&nbsp;&nbsp;
    <input type="radio" id="featured_size_large" name="oswc_front[featured_size]" value="large" <?php checked( $settings['featured_size'], 'large' ); ?> />
    <label for="featured_size_large"><?php _e('Large','made'); ?></label>
    <br />
    <?php _e( 'The size of the featured slider', 'made' ); ?>
    </td>
    </tr>
    
    <tr valign="top"><th scope="row"><label for="featured_duration"><?php _e( 'Slide Duration', 'made' ); ?></label></th>
	<td>
	<select id="featured_duration" name="oswc_front[featured_duration]">
    	<?php $i=1;
		while ($i<=30) { ?>			
    		<option value="<?php echo $i; ?>"<?php if($settings['featured_duration']==$i) { ?> selected="selected"<?php } ?>><?php echo $i; ?></option>
        <?php $i++;
		} ?>
	</select>
    <?php _e( 'Number of seconds each slide will display before rotating', 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="featured_num"><?php _e( 'Number of Slides', 'made' ); ?></label></th>
	<td>
	<select id="featured_num" name="oswc_front[featured_num]">
    	<?php $i=1;
		while ($i<=30) { ?>			
    		<option value="<?php echo $i; ?>"<?php if($settings['featured_num']==$i) { ?> selected="selected"<?php } ?>><?php echo $i; ?></option>
        <?php $i++;
		} ?>
	</select>
    <?php _e( 'Number of slides to rotate through', 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="featured_tag"><?php _e( 'Featured Tag', 'made' ); ?></label></th>
	<td>
	<input id="featured_tag" name="oswc_front[featured_tag]" type="text" value="<?php esc_attr_e($settings['featured_tag']); ?>" />
    <?php _e( 'Name of the tag that you want to use to mark posts as Featured', 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top">
	<td colspan="2">
	<h3><?php _e( 'Spotlight Slider', 'made' ); ?></h3>
	</td>
	</tr>

	<tr valign="top"><th scope="row"><?php _e( 'Display Slider', 'made' ); ?></th>
	<td>
	<input type="checkbox" id="spotlight_show" name="oswc_front[spotlight_show]" value="1" <?php checked( true, $settings['spotlight_show'] ); ?> />
    <label for="spotlight_show"><?php _e( 'Display the Spotlight slider area below the Featured slider', 'made' ); ?></label>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><?php _e( 'Scroll Slider', 'made' ); ?></th>
	<td>
	<input type="checkbox" id="spotlight_scroll" name="oswc_front[spotlight_scroll]" value="1" <?php checked( true, $settings['spotlight_scroll'] ); ?> />
    <label for="spotlight_scroll"><?php _e( 'Should the Spotlight slider having scrolling functionality or be static?', 'made' ); ?></label>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="spotlight_duration"><?php _e( 'Slide Duration', 'made' ); ?></label></th>
	<td>
	<select id="spotlight_duration" name="oswc_front[spotlight_duration]">
    	<?php $i=1;
		while ($i<=30) { ?>			
    		<option value="<?php echo $i; ?>"<?php if($settings['spotlight_duration']==$i) { ?> selected="selected"<?php } ?>><?php echo $i; ?></option>
        <?php $i++;
		} ?>
	</select>
    <?php _e( 'Number of seconds each slide will display before rotating', 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="spotlight_num"><?php _e( 'Number of Slides', 'made' ); ?></label></th>
	<td>
	<select id="spotlight_num" name="oswc_front[spotlight_num]">
    	<?php $i=2;
		while ($i<=20) { ?>			
    		<option value="<?php echo $i; ?>"<?php if($settings['spotlight_num']==$i) { ?> selected="selected"<?php } ?>><?php echo $i; ?></option>
        <?php $i++;
		$i++;
		} ?>
	</select><br />
    <?php _e( 'Number of slides to rotate through. Make sure you actually have this many posts tagged (or in the assigned category or review) or else the style will not display correctly.', 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="spotlight_header"><?php _e( 'Header Text', 'made' ); ?></label></th>
	<td>
	<input id="spotlight_header" name="oswc_front[spotlight_header]" type="text" value="<?php esc_attr_e($settings['spotlight_header']); ?>" /><br />
    <?php _e( 'Text to use for the Spotlight header', 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="spotlight_type"><?php _e( 'Type of Posts', 'made' ); ?></label></th>
	<td>
	<select id="spotlight_type" name="oswc_front[spotlight_type]">    			
    	<option value="tag"<?php if($settings['spotlight_type']=='tag') { ?> selected="selected"<?php } ?>><?php _e( 'Tag','made'); ?></option>  
        <option value="category"<?php if($settings['spotlight_type']=='category') { ?> selected="selected"<?php } ?>><?php _e( 'Category','made'); ?></option> 
        <option value="review"<?php if($settings['spotlight_type']=='review') { ?> selected="selected"<?php } ?>><?php _e( 'Review Type','made'); ?></option> 
        <option value="latest"<?php if($settings['spotlight_type']=='latest') { ?> selected="selected"<?php } ?>><?php _e( 'Latest Articles','made'); ?></option>         
	</select>
    <?php _e( 'The type of posts to look for to populate the slider', 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="spotlight_tags"><?php _e( 'Type Name', 'made' ); ?></label></th>
	<td>
	<input id="spotlight_tags" name="oswc_front[spotlight_tags]" type="text" value="<?php esc_attr_e($settings['spotlight_tags']); ?>" /><br />
    <?php _e( 'Name of the tag, category, or review type that you want to use to mark posts as Spotlight. This setting does not apply if you have selected "Latest" as the type in the setting above.', 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top">
	<td colspan="2">
	<h3><?php _e( 'Tabbed Posts', 'made' ); ?></h3>
	</td>
	</tr>

	<tr valign="top"><th scope="row"><?php _e( 'Display Tabbed Posts', 'made' ); ?></th>
	<td>
	<input type="checkbox" id="tabs_show" name="oswc_front[tabs_show]" value="1" <?php checked( true, $settings['tabs_show'] ); ?> />
    <label for="tabs_show"><?php _e( 'Display the Tabbed Posts area below the Spotlight slider', 'made' ); ?></label>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="tabs_type"><?php _e( 'Type of Posts', 'made' ); ?></label></th>
	<td>
	<select id="tabs_type" name="oswc_front[tabs_type]">    			
    	<option value="tag"<?php if($settings['tabs_type']=='tag') { ?> selected="selected"<?php } ?>><?php _e( 'Tags','made'); ?></option>  
        <option value="category"<?php if($settings['tabs_type']=='category') { ?> selected="selected"<?php } ?>><?php _e( 'Categories','made'); ?></option> 
        <option value="review"<?php if($settings['tabs_type']=='review') { ?> selected="selected"<?php } ?>><?php _e( 'Review Types','made'); ?></option>                 
	</select>
    <?php _e( 'The type of posts to look for to populate the tabs', 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="tabs_cats"><?php _e( 'Type Names', 'made' ); ?></label></th>
	<td>
	<input id="tabs_cats" name="oswc_front[tabs_cats]" type="text" value="<?php esc_attr_e($settings['tabs_cats']); ?>" style="width:500px" /><br />
    <?php _e( 'Names of the tags, categories, or review types that you want to use for the tabs. Separate tags, categories, or review types by a comma, and one tab will be created for each term. You cannot mix and match tags, categories, and review types. Depending on the length of your names, the tabs could expand to a second line which will break the functionality of the tabs. If this happens, remove an item from the list until the tabs go back to only one line.', 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="tabs_numberpanel"><?php _e( 'Number of posts per tab', 'made' ); ?></label></th>
	<td>
	<select id="tabs_numberpanel" name="oswc_front[tabs_numberpanel]">
    	<?php $i=3;
		while ($i<=60) { ?>			
    		<option value="<?php echo $i; ?>"<?php if($settings['tabs_numberpanel']==$i) { ?> selected="selected"<?php } ?>><?php echo $i; ?></option>
        <?php $i++;
		} ?>
	</select><br />
    <?php _e( 'Number of posts to display within each of the tabs.', 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top">
	<td colspan="2">
	<h3><?php _e( 'Trending Slider', 'made' ); ?></h3>
	</td>
	</tr>

	<tr valign="top"><th scope="row"><?php _e( 'Display Slider', 'made' ); ?></th>
	<td>
	<input type="checkbox" id="trending_show" name="oswc_front[trending_show]" value="1" <?php checked( true, $settings['trending_show'] ); ?> />
    <label for="trending_show"><?php _e( 'Display the Trending Slider below the Spotlight slider', 'made' ); ?></label>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="trending_num"><?php _e( 'Number of Slides', 'made' ); ?></label></th>
	<td>
	<select id="trending_num" name="oswc_front[trending_num]">
    	<?php $i=5;
		while ($i<=30) { ?>			
    		<option value="<?php echo $i; ?>"<?php if($settings['trending_num']==$i) { ?> selected="selected"<?php } ?>><?php echo $i; ?></option>
        <?php $i++;
		} ?>
	</select><br />
    <?php _e( 'Number of slides to rotate through. Make sure you actually have this many posts tagged (or in the assigned category or review) or else the style will not display correctly.', 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="trending_header"><?php _e( 'Header Text', 'made' ); ?></label></th>
	<td>
	<input id="trending_header" name="oswc_front[trending_header]" type="text" value="<?php esc_attr_e($settings['trending_header']); ?>" /><br />
    <?php _e( 'Text to use for the Trending Slider header', 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="trending_type"><?php _e( 'Type of Posts', 'made' ); ?></label></th>
	<td>
	<select id="trending_type" name="oswc_front[trending_type]">    			
    	<option value="tag"<?php if($settings['trending_type']=='tag') { ?> selected="selected"<?php } ?>><?php _e( 'Tag','made'); ?></option>  
        <option value="category"<?php if($settings['trending_type']=='category') { ?> selected="selected"<?php } ?>><?php _e( 'Category','made'); ?></option> 
        <option value="review"<?php if($settings['trending_type']=='review') { ?> selected="selected"<?php } ?>><?php _e( 'Review Type','made'); ?></option> 
        <option value="latest"<?php if($settings['trending_type']=='latest') { ?> selected="selected"<?php } ?>><?php _e( 'Latest Articles','made'); ?></option>         
	</select>
    <?php _e( 'The type of posts to look for to populate the slider', 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="trending_tags"><?php _e( 'Type Name', 'made' ); ?></label></th>
	<td>
	<input id="trending_tags" name="oswc_front[trending_tags]" type="text" value="<?php esc_attr_e($settings['trending_tags']); ?>" /><br />
    <?php _e( 'Name of the tag, category, or review type that you want to use to mark posts as Trending posts. This setting does not apply if you have selected "Latest" as the type in the setting above.', 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top">
	<td colspan="2">
	<h3><?php _e( 'Category Panels', 'made' ); ?></h3>
	</td>
	</tr>

	<tr valign="top"><th scope="row"><?php _e( 'Display Category Panels', 'made' ); ?></th>
	<td>
	<input type="checkbox" id="categorypanels_show" name="oswc_front[categorypanels_show]" value="1" <?php checked( true, $settings['categorypanels_show'] ); ?> />
    <label for="categorypanels_show"><?php _e( 'Display the Category Panels below the Trending Slider', 'made' ); ?></label>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="categorypanels_numberpanel"><?php _e( 'Number of posts per panel', 'made' ); ?></label></th>
	<td>
	<select id="categorypanels_numberpanel" name="oswc_front[categorypanels_numberpanel]">
    	<?php $i=1;
		while ($i<=30) { ?>			
    		<option value="<?php echo $i; ?>"<?php if($settings['categorypanels_numberpanel']==$i) { ?> selected="selected"<?php } ?>><?php echo $i; ?></option>
        <?php $i++;
		} ?>
	</select><br />
    <?php _e( 'Number of articles to be displayed within each category panel, including the first, larger post in the list.', 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="categorypanels_cats_headers"><?php _e( 'Header Text', 'made' ); ?></label></th>
	<td>
	<input id="categorypanels_cats_headers" name="oswc_front[categorypanels_cats_headers]" type="text" value="<?php esc_attr_e($settings['categorypanels_cats_headers']); ?>" /><br />
    <?php _e( 'Text to use as a prefix for the name of the category', 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><?php _e( 'Large First Post', 'made' ); ?></th>
	<td>
	<input type="checkbox" id="categorypanel_largepost" name="oswc_front[categorypanel_largepost]" value="1" <?php checked( true, $settings['categorypanel_largepost'] ); ?> />
    <label for="categorypanel_largepost"><?php _e( 'The first post in the list should be larger with the thumbnail above the title and excerpt.', 'made' ); ?></label>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="categorypanels_type"><?php _e( 'Type of Posts', 'made' ); ?></label></th>
	<td>
	<select id="categorypanels_type" name="oswc_front[categorypanels_type]">    			
    	<option value="tag"<?php if($settings['categorypanels_type']=='tag') { ?> selected="selected"<?php } ?>><?php _e( 'Tags','made'); ?></option>  
        <option value="category"<?php if($settings['categorypanels_type']=='category') { ?> selected="selected"<?php } ?>><?php _e( 'Categories','made'); ?></option> 
        <option value="review"<?php if($settings['categorypanels_type']=='review') { ?> selected="selected"<?php } ?>><?php _e( 'Review Types','made'); ?></option>        
	</select>
    <?php _e( 'The type of posts to look for to populate the category panels', 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="categorypanels_cats"><?php _e( 'Type Name(s)', 'made' ); ?></label></th>
	<td>
	<input id="categorypanels_cats" name="oswc_front[categorypanels_cats]" type="text" value="<?php esc_attr_e($settings['categorypanels_cats']); ?>" style="width:500px" /><br />
    <?php _e( 'Names of the tags, categories, or review types that you want to use to mark posts as Category Panel posts. Separate tags, categories, or review types by a comma, and one Category Panel will be created for each term. You cannot mix and match tags, categories, and review types. You can specify as many terms as you want and that number of category panels will be created (they can stack on top of each other).', 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top">
	<td colspan="2">
	<h3><?php _e( 'Latest Posts', 'made' ); ?></h3>
	</td>
	</tr>

	<tr valign="top"><th scope="row"><?php _e( 'Display Latest Posts', 'made' ); ?></th>
	<td>
	<input type="checkbox" id="latestposts_show" name="oswc_front[latestposts_show]" value="1" <?php checked( true, $settings['latestposts_show'] ); ?> />
    <label for="latestposts_show"><?php _e( 'Display your latest posts in a regular blog format on your front page', 'made' ); ?></label>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="latestposts_num"><?php _e( 'Number of latest posts', 'made' ); ?></label></th>
	<td>
	<select id="latestposts_num" name="oswc_front[latestposts_num]">
    	<?php $i=1;
		while ($i<=20) { ?>			
    		<option value="<?php echo $i; ?>"<?php if($settings['latestposts_num']==$i) { ?> selected="selected"<?php } ?>><?php echo $i; ?></option>
        <?php $i++;
		} ?>
	</select><br />
    <?php _e( 'Number of latest posts to display per page', 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="latestposts_header"><?php _e( 'Header Text', 'made' ); ?></label></th>
	<td>
	<input id="latestposts_header" name="oswc_front[latestposts_header]" type="text" value="<?php esc_attr_e($settings['latestposts_header']); ?>" /><br />
    <?php _e( 'Text to use for the Latest Posts header', 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><?php _e( 'Latest Layout', 'made' ); ?></th>
    <td>
    <div class="radiowrapper">
        <div class="radiobutton">
            A<br />
            <input type="radio" id="latest_layout_A" name="oswc_front[latest_layout]" value="A" <?php checked( $settings['latest_layout'], "A" ); ?> />
        </div>
        <div class="radioimage">
            <label for="latest_layout_A"><img src="<?php echo get_template_directory_uri(); ?>/functions/images/post-layout-A.png" alt="layout A" /></label>
        </div>
    </div>
    <div class="radiowrapper">
        <div class="radiobutton">
            B<br />
            <input type="radio" id="latest_layout_B" name="oswc_front[latest_layout]" value="B" <?php checked( $settings['latest_layout'], "B" ); ?> />
        </div>
        <div class="radioimage">
            <label for="latest_layout_B"><img src="<?php echo get_template_directory_uri(); ?>/functions/images/post-layout-B.png" alt="layout B" /></label>
        </div>
    </div>
    <div class="radiowrapper">
        <div class="radiobutton">
            C<br />
            <input type="radio" id="latest_layout_C" name="oswc_front[latest_layout]" value="C" <?php checked( $settings['latest_layout'], "C" ); ?> />
        </div>
        <div class="radioimage">
            <label for="latest_layout_C"><img src="<?php echo get_template_directory_uri(); ?>/functions/images/post-layout-C.png" alt="layout C" /></label>
        </div>
    </div>
    </td>
    </tr>
    
    <tr valign="top"><th scope="row"><?php _e( 'Show Excerpt', 'made' ); ?></th>
	<td>
	<input type="checkbox" id="latest_excerpt_enabled" name="oswc_front[latest_excerpt_enabled]" value="1" <?php checked( true, $settings['latest_excerpt_enabled'] ); ?> />
    <label for="latest_excerpt_enabled"><?php _e( 'Show the excerpt for the latest posts on the front page', 'made' ); ?></label>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><?php _e( 'Show More', 'made' ); ?></th>
	<td>
	<input type="checkbox" id="latest_more_enabled" name="oswc_front[latest_more_enabled]" value="1" <?php checked( true, $settings['latest_more_enabled'] ); ?> />
    <label for="latest_more_enabled"><?php _e( 'Show the more area for the latest posts on the front page. This is the meta area that houses things like rating, comments, date, tags, etc.', 'made' ); ?></label>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="latest_category"><?php _e( 'Category Name', 'made' ); ?></label></th>
	<td>
	<input id="latest_category" name="oswc_front[latest_category]" type="text" value="<?php esc_attr_e($settings['latest_category']); ?>" /><br />
    <?php _e( 'Limit the latest posts on the front page to a specific category name.', 'made' ); ?>
	</td>
	</tr>
    
	</table>

	<p class="submit"><input type="submit" class="button-primary" value="Save Options" /></p>

	</form>

	</div>

	<?php
}

// Function to generate options page
function theme_single_options() {
	global $oswc_single;

	if ( ! isset( $_REQUEST['updated'] ) )
		$_REQUEST['updated'] = false; // This checks whether the form has just been submitted. ?>

	<?php if ( false !== $_REQUEST['updated'] ) : ?>
	<div class="updated fade"><p><strong><?php _e( 'Options saved', 'made' ); ?></strong></p></div>
	<?php endif; // If the form has just been submitted, this shows the notification ?>

	<form method="post" action="options.php">

	<?php $settings = get_option( 'oswc_single', $oswc_single ); ?>
	
	<?php settings_fields( 'oswc_theme_single' );
	/* This function outputs some hidden fields required by the form,
	including a nonce, a unique number used to ensure the form has been submitted from the admin page
	and not somewhere else, very important for security */ ?>
    
    <p class="submit"><input type="submit" class="button-primary" value="Save Options" /></p>
    
    <table class="form-table">
    
    <tr valign="top">
	<td colspan="2">
	<h3><?php _e( 'Single Post Options', 'made' ); ?></h3>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><?php _e( 'Hide Sidebar', 'made' ); ?></th>
	<td>
	<input type="checkbox" id="post_sidebar_hide" name="oswc_single[post_sidebar_hide]" value="1" <?php checked( true, $settings['post_sidebar_hide'] ); ?> />
    <label for="post_sidebar_hide"><?php _e( 'Hide sidebar on single posts', 'made' ); ?></label>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><?php _e( 'Unique Sidebar', 'made' ); ?></th>
	<td>
	<input type="checkbox" id="post_sidebar_unique" name="oswc_single[post_sidebar_unique]" value="1" <?php checked( true, $settings['post_sidebar_unique'] ); ?> />
    <label for="post_sidebar_unique"><?php _e( 'Display widgets from the Single Post Sidebar widget panel instead of the Default Sidebar widget panel', 'made' ); ?></label>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><?php _e( 'Featured Image + Video', 'made' ); ?></th>
	<td>
	<input type="checkbox" id="post_featured_image_video_show" name="oswc_single[post_featured_image_video_show]" value="1" <?php checked( true, $settings['post_featured_image_video_show'] ); ?> />
    <label for="post_featured_image_video_show"><?php _e( 'For posts that have both a featured image and a featured video, show both the image and the video on the single post page instead of just the video', 'made' ); ?></label>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><?php _e( 'Hide Featured Images', 'made' ); ?></th>
	<td>
	<input type="checkbox" id="post_featured_image_hide" name="oswc_single[post_featured_image_hide]" value="1" <?php checked( true, $settings['post_featured_image_hide'] ); ?> />
    <label for="post_featured_image_hide"><?php _e( 'Hide featured images on all single posts.', 'made' ); ?></label>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><span class="special"><?php _e( 'Hide Tags', 'made' ); ?></span></th>
	<td>
	<input type="checkbox" id="post_tags_hide" name="oswc_single[post_tags_hide]" value="1" <?php checked( true, $settings['post_tags_hide'] ); ?> />
    <label for="post_tags_hide"><?php _e( 'Hide the tag list underneath the post content', 'made' ); ?></label>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><span class="special"><?php _e( 'Hide Related', 'made' ); ?></span></th>
	<td>
	<input type="checkbox" id="post_related_hide" name="oswc_single[post_related_hide]" value="1" <?php checked( true, $settings['post_related_hide'] ); ?> />
    <label for="post_related_hide"><?php _e( 'Hide the Related panel underneath the post content', 'made' ); ?></label>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="post_related_number"><?php _e( 'Related Number of Posts', 'made' ); ?></label></th>
	<td>
	<select id="post_related_number" name="oswc_single[post_related_number]">
    	<?php $i=1;
		while ($i<=20) { ?>			
    		<option value="<?php echo $i; ?>"<?php if($settings['post_related_number']==$i) { ?> selected="selected"<?php } ?>><?php echo $i; ?></option>
        <?php $i++;
		} ?>
	</select>
    <?php _e( 'Number of articles to be displayed inside each related tab', 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="post_related_header_text"><?php _e( 'Related Header Text', 'made' ); ?></label></th>
	<td>
	<input id="post_related_header_text" name="oswc_single[post_related_header_text]" type="text" value="<?php esc_attr_e($settings['post_related_header_text']); ?>" />
    <?php _e( 'Text to use for the Related panel header', 'made' ); ?>
	</td>
	</tr>

	<tr valign="top"><th scope="row"><span class="special"><?php _e( 'Hide Trending', 'made' ); ?></span></th>
	<td>
	<input type="checkbox" id="post_trending_hide" name="oswc_single[post_trending_hide]" value="1" <?php checked( true, $settings['post_trending_hide'] ); ?> />
    <label for="post_trending_hide"><?php _e( 'Hide the trending slider that appears at the bottom of the single posts above the footer', 'made' ); ?></label>
	</td>
	</tr>
    
    <tr valign="top">
	<td colspan="2">
	<h3><?php _e( 'Single Review Options', 'made' ); ?></h3>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><?php _e( 'Unique Sidebar', 'made' ); ?></th>
	<td>
	<input type="checkbox" id="review_sidebar_unique" name="oswc_single[review_sidebar_unique]" value="1" <?php checked( true, $settings['review_sidebar_unique'] ); ?> />
    <label for="review_sidebar_unique"><?php _e( 'Display widgets from the designated specific review sidebar widget panel instead of the Default Sidebar widget panel', 'made' ); ?></label>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><?php _e( 'Featured Image + Video', 'made' ); ?></th>
	<td>
	<input type="checkbox" id="review_featured_image_video_show" name="oswc_single[review_featured_image_video_show]" value="1" <?php checked( true, $settings['review_featured_image_video_show'] ); ?> />
    <label for="review_featured_image_video_show"><?php _e( 'For reviews that have both a featured image and a featured video, show both the image and the video on the single review page instead of just the video', 'made' ); ?></label>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><span class="special"><?php _e( 'Hide Tags', 'made' ); ?></span></th>
	<td>
	<input type="checkbox" id="review_tags_hide" name="oswc_single[review_tags_hide]" value="1" <?php checked( true, $settings['review_tags_hide'] ); ?> />
    <label for="review_tags_hide"><?php _e( 'Hide the tag list underneath the review content', 'made' ); ?></label>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><span class="special"><?php _e( 'Hide Related', 'made' ); ?></span></th>
	<td>
	<input type="checkbox" id="review_related_hide" name="oswc_single[review_related_hide]" value="1" <?php checked( true, $settings['review_related_hide'] ); ?> />
    <label for="review_related_hide"><?php _e( 'Hide the Related panel underneath the review content', 'made' ); ?></label>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="review_related_header_text"><?php _e( 'Related Header Text', 'made' ); ?></label></th>
	<td>
	<input id="review_related_header_text" name="oswc_single[review_related_header_text]" type="text" value="<?php esc_attr_e($settings['review_related_header_text']); ?>" />
    <?php _e( 'Text to use for the Related panel header', 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><span class="special"><?php _e( 'Hide Trending', 'made' ); ?></span></th>
	<td>
	<input type="checkbox" id="review_trending_hide" name="oswc_single[review_trending_hide]" value="1" <?php checked( true, $settings['review_trending_hide'] ); ?> />
    <label for="review_trending_hide"><?php _e( 'Hide the trending slider that appears at the bottom of the single reviews above the footer', 'made' ); ?></label>
	</td>
	</tr>
    
    <tr valign="top">
	<td colspan="2">
	<h3><?php _e( 'Post + Review Options', 'made' ); ?></h3>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><span class="special"><?php _e( 'Hide Sharebox', 'made' ); ?></span></th>
	<td>
	<input type="checkbox" id="sharebox_hide" name="oswc_single[sharebox_hide]" value="1" <?php checked( true, $settings['sharebox_hide'] ); ?> />
    <label for="sharebox_hide"><?php _e( 'Hide the sharebox on all single posts and reviews', 'made' ); ?></label>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><?php _e( 'Sharebox Buttons', 'made' ); ?></th>
	<td>
	<input type="checkbox" id="twitter_show" name="oswc_single[twitter_show]" value="1" <?php checked( true, $settings['twitter_show'] ); ?> />
    <label for="twitter_show"><?php _e( 'Tweet', 'made' ); ?></label>&nbsp;&nbsp;&nbsp;&nbsp;
    <input type="checkbox" id="facebook_show" name="oswc_single[facebook_show]" value="1" <?php checked( true, $settings['facebook_show'] ); ?> />
    <label for="facebook_show"><?php _e( 'Facebook Like', 'made' ); ?></label>&nbsp;&nbsp;&nbsp;&nbsp;
    <input type="checkbox" id="plusone_show" name="oswc_single[plusone_show]" value="1" <?php checked( true, $settings['plusone_show'] ); ?> />
    <label for="plusone_show"><?php _e( 'Google +1', 'made' ); ?></label>&nbsp;&nbsp;&nbsp;&nbsp;
    <input type="checkbox" id="yahoo_show" name="oswc_single[yahoo_show]" value="1" <?php checked( true, $settings['yahoo_show'] ); ?> />
    <label for="yahoo_show"><?php _e( 'Yahoo Messenger', 'made' ); ?></label>&nbsp;&nbsp;&nbsp;&nbsp;
    <input type="checkbox" id="pinterest_show" name="oswc_single[pinterest_show]" value="1" <?php checked( true, $settings['pinterest_show'] ); ?> />
    <label for="pinterest_show"><?php _e( 'Pinterest', 'made' ); ?></label>&nbsp;&nbsp;&nbsp;&nbsp;
    <input type="checkbox" id="digg_show" name="oswc_single[digg_show]" value="1" <?php checked( true, $settings['digg_show'] ); ?> />
    <label for="digg_show"><?php _e( 'Digg', 'made' ); ?></label>&nbsp;&nbsp;&nbsp;&nbsp;
    <input type="checkbox" id="stumbleupon_show" name="oswc_single[stumbleupon_show]" value="1" <?php checked( true, $settings['stumbleupon_show'] ); ?> />
    <label for="stumbleupon_show"><?php _e( 'StumbleUpon', 'made' ); ?></label>&nbsp;&nbsp;&nbsp;&nbsp;
    <input type="checkbox" id="tumblr_show" name="oswc_single[tumblr_show]" value="1" <?php checked( true, $settings['tumblr_show'] ); ?> />
    <label for="tumblr_show"><?php _e( 'Tumblr', 'made' ); ?></label>&nbsp;&nbsp;&nbsp;&nbsp;
    <input type="checkbox" id="email_show" name="oswc_single[email_show]" value="1" <?php checked( true, $settings['email_show'] ); ?> />
    <label for="email_show"><?php _e( 'Email', 'made' ); ?></label>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><span class="special"><?php _e( 'Hide Authorbox', 'made' ); ?></span></th>
	<td>
	<input type="checkbox" id="authorbox_hide" name="oswc_single[authorbox_hide]" value="1" <?php checked( true, $settings['authorbox_hide'] ); ?> />
    <label for="authorbox_hide"><?php _e( 'Hide the authorbox on all single posts and reviews', 'made' ); ?></label>
	</td>
	</tr>
    
    </table>
    
	<p class="submit"><input type="submit" class="button-primary" value="Save Options" /></p>

	</form>

	</div>

	<?php
}

// Function to generate options page
function theme_other_options() {
	global $oswc_other;

	if ( ! isset( $_REQUEST['updated'] ) )
		$_REQUEST['updated'] = false; // This checks whether the form has just been submitted. ?>	

	<?php if ( false !== $_REQUEST['updated'] ) : ?>
	<div class="updated fade"><p><strong><?php _e( 'Options saved', 'made' ); ?></strong></p></div>
	<?php endif; // If the form has just been submitted, this shows the notification ?>

	<form method="post" action="options.php">

	<?php $settings = get_option( 'oswc_other', $oswc_other ); ?>
	
	<?php settings_fields( 'oswc_theme_other' );
	/* This function outputs some hidden fields required by the form,
	including a nonce, a unique number used to ensure the form has been submitted from the admin page
	and not somewhere else, very important for security */ ?>

	<div class="rm_wrap">
        <div class="rm_opts">
        
        	<?php //archive pages ?>
            <div class="rm_section">
                <div class="rm_title">
                    <h3><img src="<?php echo get_template_directory_uri(); ?>/functions/images/trans.png" class="inactive" alt="plus" /><?php _e( 'Archive Pages', 'made' ); ?></h3>
                    <span class="submit">
                        <input type="submit" value="Save Options" />
                    </span>
                    <div class="clearfix"></div>
                </div>
            
                <div class="rm_options">
        
                    <table class="form-table">
                    
                    <tr valign="top"><th scope="row"><?php _e( 'Archive Layout', 'made' ); ?></th>
                    <td>
                    <div class="radiowrapper">
                        <div class="radiobutton">
                            A<br />
                            <input type="radio" id="archive_layout_A" name="oswc_other[archive_layout]" value="A" <?php checked( $settings['archive_layout'], "A" ); ?> />
                        </div>
                        <div class="radioimage">
                            <label for="archive_layout_A"><img src="<?php echo get_template_directory_uri(); ?>/functions/images/post-layout-A.png" alt="layout A" /></label>
                        </div>
                    </div>
                    <div class="radiowrapper">
                        <div class="radiobutton">
                            B<br />
                            <input type="radio" id="archive_layout_B" name="oswc_other[archive_layout]" value="B" <?php checked( $settings['archive_layout'], "B" ); ?> />
                        </div>
                        <div class="radioimage">
                            <label for="archive_layout_B"><img src="<?php echo get_template_directory_uri(); ?>/functions/images/post-layout-B.png" alt="layout B" /></label>
                        </div>
                    </div>
                    <div class="radiowrapper">
                        <div class="radiobutton">
                            C<br />
                            <input type="radio" id="archive_layout_C" name="oswc_other[archive_layout]" value="C" <?php checked( $settings['archive_layout'], "C" ); ?> />
                        </div>
                        <div class="radioimage">
                            <label for="archive_layout_C"><img src="<?php echo get_template_directory_uri(); ?>/functions/images/post-layout-C.png" alt="layout C" /></label>
                        </div>
                    </div>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><?php _e( "Hide Don't Miss", 'made' ); ?></th>
                    <td>
                    <input type="checkbox" id="archive_dontmiss_hide" name="oswc_other[archive_dontmiss_hide]" value="1" <?php checked( true, $settings['archive_dontmiss_hide'] ); ?> />
                    <label for="archive_dontmiss_hide"><?php _e( "Hide the Don't Miss Bar", 'made' ); ?></label>
                    </td>
                    </tr>	
                    
                    <tr valign="top"><th scope="row"><?php _e( 'Hide Latest', 'made' ); ?></th>
                    <td>
                    <input type="checkbox" id="archive_latest_hide" name="oswc_other[archive_latest_hide]" value="1" <?php checked( true, $settings['archive_latest_hide'] ); ?> />
                    <label for="archive_latest_hide"><?php _e( 'Hide the latest slider', 'made' ); ?></label>
                    </td>
                    </tr>	
                
                    <tr valign="top"><th scope="row"><?php _e( 'Unique Sidebar', 'made' ); ?></th>
                    <td>
                    <input type="checkbox" id="archive_sidebar_unique" name="oswc_other[archive_sidebar_unique]" value="1" <?php checked( true, $settings['archive_sidebar_unique'] ); ?> />
                    <label for="archive_sidebar_unique"><?php _e( 'Display widgets from the Archive Sidebar widget panel instead of the Default Sidebar widget panel', 'made' ); ?></label>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><?php _e( 'Display Sidebar', 'made' ); ?></th>
                    <td>
                    <input type="checkbox" id="archive_sidebar_show" name="oswc_other[archive_sidebar_show]" value="1" <?php checked( true, $settings['archive_sidebar_show'] ); ?> />
                    <label for="archive_sidebar_show"><?php _e( 'Display the sidebar on archive listing pages', 'made' ); ?></label>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><label for="archive_header"><?php _e( 'Header Text', 'made' ); ?></label></th>
                    <td>
                    <input id="archive_header" name="oswc_other[archive_header]" type="text" value="<?php esc_attr_e($settings['archive_header']); ?>" /><br />
                    <?php _e( 'Text to use as the header text instead of the default archive text headers', 'made' ); ?>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><?php _e( 'Display Meta', 'made' ); ?></th>
                    <td>
                    <input type="checkbox" id="archive_meta_enabled" name="oswc_other[archive_meta_enabled]" value="1" <?php checked( true, $settings['archive_meta_enabled'] ); ?> />
                    <label for="archive_meta_enabled"><?php _e( 'Display the meta info for each post listed in the archives', 'made' ); ?></label>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><?php _e( 'Display Excerpt', 'made' ); ?></th>
                    <td>
                    <input type="checkbox" id="archive_excerpt_enabled" name="oswc_other[archive_excerpt_enabled]" value="1" <?php checked( true, $settings['archive_excerpt_enabled'] ); ?> />
                    <label for="archive_excerpt_enabled"><?php _e( 'Display the excerpt for each post listed in the archives', 'made' ); ?></label>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><?php _e( 'Display Trending', 'made' ); ?></th>
                    <td>
                    <input type="checkbox" id="archive_trending_enabled" name="oswc_other[archive_trending_enabled]" value="1" <?php checked( true, $settings['archive_trending_enabled'] ); ?> />
                    <label for="archive_trending_enabled"><?php _e( 'Display the trending slider at the bottom of the archive page above the footer', 'made' ); ?></label>
                    </td>
                    </tr>
                                
                    </table>
                
                </div>
            </div>    
            <br />
            
            <?php //search results ?>
            <div class="rm_section">
                <div class="rm_title">
                    <h3><img src="<?php echo get_template_directory_uri(); ?>/functions/images/trans.png" class="inactive" alt="plus" /><?php _e( 'Search Results', 'made' ); ?></h3>
                    <span class="submit">
                        <input type="submit" value="Save Options" />
                    </span>
                    <div class="clearfix"></div>
                </div>
            
                <div class="rm_options">
        
                    <table class="form-table">
                    
                    <tr valign="top"><th scope="row"><?php _e( "Hide Don't Miss", 'made' ); ?></th>
                    <td>
                    <input type="checkbox" id="search_dontmiss_hide" name="oswc_other[search_dontmiss_hide]" value="1" <?php checked( true, $settings['search_dontmiss_hide'] ); ?> />
                    <label for="search_dontmiss_hide"><?php _e( "Hide the Don't Miss Bar", 'made' ); ?></label>
                    </td>
                    </tr>	
                    
                    <tr valign="top"><th scope="row"><?php _e( 'Hide Latest', 'made' ); ?></th>
                    <td>
                    <input type="checkbox" id="search_latest_hide" name="oswc_other[search_latest_hide]" value="1" <?php checked( true, $settings['search_latest_hide'] ); ?> />
                    <label for="search_latest_hide"><?php _e( 'Hide the latest slider', 'made' ); ?></label>
                    </td>
                    </tr>	
                
                    <tr valign="top"><th scope="row"><?php _e( 'Unique Sidebar', 'made' ); ?></th>
                    <td>
                    <input type="checkbox" id="search_sidebar_unique" name="oswc_other[search_sidebar_unique]" value="1" <?php checked( true, $settings['search_sidebar_unique'] ); ?> />
                    <label for="search_sidebar_unique"><?php _e( 'Display widgets from the Archive Sidebar widget panel instead of the Default Sidebar widget panel', 'made' ); ?></label>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><?php _e( 'Display Meta', 'made' ); ?></th>
                    <td>
                    <input type="checkbox" id="search_meta_enabled" name="oswc_other[search_meta_enabled]" value="1" <?php checked( true, $settings['search_meta_enabled'] ); ?> />
                    <label for="search_meta_enabled"><?php _e( 'Display the meta info for each post listed in the search results', 'made' ); ?></label>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><?php _e( 'Display Excerpt', 'made' ); ?></th>
                    <td>
                    <input type="checkbox" id="search_excerpt_enabled" name="oswc_other[search_excerpt_enabled]" value="1" <?php checked( true, $settings['search_excerpt_enabled'] ); ?> />
                    <label for="search_excerpt_enabled"><?php _e( 'Display the excerpt for each post listed in the search results', 'made' ); ?></label>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><?php _e( 'Display More Button', 'made' ); ?></th>
                    <td>
                    <input type="checkbox" id="search_more_enabled" name="oswc_other[search_more_enabled]" value="1" <?php checked( true, $settings['search_more_enabled'] ); ?> />
                    <label for="search_more_enabled"><?php _e( 'Display the more button for each post listed in the search results', 'made' ); ?></label>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><?php _e( 'Display Trending', 'made' ); ?></th>
                    <td>
                    <input type="checkbox" id="search_trending_enabled" name="oswc_other[search_trending_enabled]" value="1" <?php checked( true, $settings['search_trending_enabled'] ); ?> />
                    <label for="search_trending_enabled"><?php _e( 'Display the trending slider at the bottom of the search results page above the footer', 'made' ); ?></label>
                    </td>
                    </tr>
                
                    </table>
                
                </div>
            </div>    
            <br />
            
            <?php //authors page ?>
            <div class="rm_section">
                <div class="rm_title">
                    <h3><img src="<?php echo get_template_directory_uri(); ?>/functions/images/trans.png" class="inactive" alt="plus" /><?php _e( 'Authors Page', 'made' ); ?></h3>
                    <span class="submit">
                        <input type="submit" value="Save Options" />
                    </span>
                    <div class="clearfix"></div>
                </div>
            
                <div class="rm_options">
        
                    <table class="form-table">
                    
                    <tr valign="top"><th scope="row"><?php _e( "Hide Don't Miss", 'made' ); ?></th>
                    <td>
                    <input type="checkbox" id="author_dontmiss_hide" name="oswc_other[author_dontmiss_hide]" value="1" <?php checked( true, $settings['author_dontmiss_hide'] ); ?> />
                    <label for="author_dontmiss_hide"><?php _e( "Hide the Don't Miss Bar", 'made' ); ?></label>
                    </td>
                    </tr>	
                    
                    <tr valign="top"><th scope="row"><?php _e( 'Hide Latest', 'made' ); ?></th>
                    <td>
                    <input type="checkbox" id="author_latest_hide" name="oswc_other[author_latest_hide]" value="1" <?php checked( true, $settings['author_latest_hide'] ); ?> />
                    <label for="author_latest_hide"><?php _e( 'Hide the latest slider', 'made' ); ?></label>
                    </td>
                    </tr>	
                    
                    <tr valign="top"><th scope="row"><?php _e( 'Unique Sidebar', 'made' ); ?></th>
                    <td>
                    <input type="checkbox" id="author_sidebar_unique" name="oswc_other[author_sidebar_unique]" value="1" <?php checked( true, $settings['author_sidebar_unique'] ); ?> />
                    <label for="author_sidebar_unique"><?php _e( 'Display widgets from the Author Sidebar widget panel instead of the Default Sidebar widget panel', 'made' ); ?></label>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><label for="author_header"><?php _e( 'Header Text', 'made' ); ?></label></th>
                    <td>
                    <input id="author_header" name="oswc_other[author_header]" type="text" value="<?php esc_attr_e($settings['author_header']); ?>" /><br />
                    <?php _e( 'Text to use as the header text of the author page', 'made' ); ?>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><label for="author_exclude"><?php _e( 'Exclude Authors', 'made' ); ?></label></th>
                    <td>
                    <input id="author_exclude" name="oswc_other[author_exclude]" type="text" value="<?php esc_attr_e($settings['author_exclude']); ?>" style="width:550px;" /><br />
                    <?php _e( 'Comma-separated list of usernames to exclude from the author list (e.g. jdoe, bmcculloh, admin)', 'made' ); ?>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><?php _e( 'Display Trending', 'made' ); ?></th>
                    <td>
                    <input type="checkbox" id="author_trending_enabled" name="oswc_other[author_trending_enabled]" value="1" <?php checked( true, $settings['author_trending_enabled'] ); ?> />
                    <label for="author_trending_enabled"><?php _e( 'Display the trending slider at the bottom of the author page above the footer', 'made' ); ?></label>
                    </td>
                    </tr>
                
                    </table>
                
                </div>
            </div>    
            <br />
            
            <?php //more pages ?>
            <div class="rm_section">
                <div class="rm_title">
                    <h3><img src="<?php echo get_template_directory_uri(); ?>/functions/images/trans.png" class="inactive" alt="plus" /><?php _e( 'More Page Options', 'made' ); ?></h3>
                    <span class="submit">
                        <input type="submit" value="Save Options" />
                    </span>
                    <div class="clearfix"></div>
                </div>
            
                <div class="rm_options">
        
                    <table class="form-table">
                    
                    <tr valign="top"><th scope="row"><?php _e( "Review Directory Sidebar", 'made' ); ?></th>
                    <td>
                    <input type="checkbox" id="directory_sidebar_enabled" name="oswc_other[directory_sidebar_enabled]" value="1" <?php checked( true, $settings['directory_sidebar_enabled'] ); ?> />
                    <label for="directory_sidebar_enabled"><?php _e( "Show the sidebar on the review directory listing page", 'made' ); ?></label>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><label for="directory_exclude_type"><?php _e( 'Exclude Type(s) From Directory', 'made' ); ?></label></th>
                    <td>
                    <input id="directory_exclude_type" name="oswc_other[directory_exclude_type]" type="text" value="<?php esc_attr_e($settings['directory_exclude_type']); ?>" style="width:550px;" /><br />
                    <?php _e( 'Comma-separated list of review types to exclude from the review directory listing page(s) (e.g. Movie, Fashion)', 'made' ); ?>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><?php _e( "404 Hide Don't Miss", 'made' ); ?></th>
                    <td>
                    <input type="checkbox" id="404_dontmiss_hide" name="oswc_other[404_dontmiss_hide]" value="1" <?php checked( true, $settings['404_dontmiss_hide'] ); ?> />
                    <label for="404_dontmiss_hide"><?php _e( "Hide the Don't Miss Bar on 404 pages", 'made' ); ?></label>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><?php _e( '404 Hide Latest', 'made' ); ?></th>
                    <td>
                    <input type="checkbox" id="404_latest_hide" name="oswc_other[404_latest_hide]" value="1" <?php checked( true, $settings['404_latest_hide'] ); ?> />
                    <label for="404_latest_hide"><?php _e( 'Hide the latest slider on 404 pages', 'made' ); ?></label>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><?php _e( '404 Unique Sidebar', 'made' ); ?></th>
                    <td>
                    <input type="checkbox" id="404_sidebar_unique" name="oswc_other[404_sidebar_unique]" value="1" <?php checked( true, $settings['404_sidebar_unique'] ); ?> />
                    <label for="404_sidebar_unique"><?php _e( 'Display widgets from the Archive Sidebar widget panel instead of the Default Sidebar widget panel', 'made' ); ?></label>
                    </td>
                    </tr>	
                    
                    <tr valign="top"><th scope="row"><?php _e( '404 Display Trending', 'made' ); ?></th>
                    <td>
                    <input type="checkbox" id="404_trending_enabled" name="oswc_other[404_trending_enabled]" value="1" <?php checked( true, $settings['404_trending_enabled'] ); ?> />
                    <label for="404_trending_enabled"><?php _e( 'Display the trending slider at the bottom of 404 pages above the footer', 'made' ); ?></label>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><?php _e( 'Page Unique Sidebar', 'made' ); ?></th>
                    <td>
                    <input type="checkbox" id="page_sidebar_unique" name="oswc_other[page_sidebar_unique]" value="1" <?php checked( true, $settings['page_sidebar_unique'] ); ?> />
                    <label for="page_sidebar_unique"><?php _e( 'Display widgets from the Page Sidebar widget panel instead of the Default Sidebar widget panel on pages', 'made' ); ?></label>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><span class="special"><?php _e( 'Page Hide Trending', 'made' ); ?></span></th>
                    <td>
                    <input type="checkbox" id="page_trending_hide" name="oswc_other[page_trending_hide]" value="1" <?php checked( true, $settings['page_trending_hide'] ); ?> />
                    <label for="page_trending_hide"><?php _e( 'Hide the trending slider at the bottom of pages above the footer', 'made' ); ?></label>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><span class="special"><?php _e( 'Full-Width Hide Trending', 'made' ); ?></span></th>
                    <td>
                    <input type="checkbox" id="full_width_trending_hide" name="oswc_other[full_width_trending_hide]" value="1" <?php checked( true, $settings['full_width_trending_hide'] ); ?> />
                    <label for="full_width_trending_hide"><?php _e( 'Hide the trending slider at the bottom of full-width pages above the footer', 'made' ); ?></label>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><?php _e( 'Reviews Unique Sidebar', 'made' ); ?></th>
                    <td>
                    <input type="checkbox" id="review_sidebar_unique" name="oswc_other[review_sidebar_unique]" value="1" <?php checked( true, $settings['review_sidebar_unique'] ); ?> />
                    <label for="review_sidebar_unique"><?php _e( 'Display widgets from a review-specific sidebar widget panel instead of the Default Sidebar widget panel on review pages', 'made' ); ?></label>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><label for="review_num"><?php _e( 'Reviews Per Page', 'made' ); ?></label></th>
                    <td>
                    <select id="review_num" name="oswc_other[review_num]">
                        <?php $i=1;
                        while ($i<=40) { ?>			
                            <option value="<?php echo $i; ?>"<?php if($settings['review_num']==$i) { ?> selected="selected"<?php } ?>><?php echo $i; ?></option>
                        <?php $i++;
                        } ?>
                    </select><br />
                    <?php _e( 'Number of reviews to display per page. This refers to the review mini-site front pages as well as the taxonomy (review category) pages.', 'made' ); ?>
                    </td>
                    </tr>
                
                    </table>
                
                </div>
            </div>    
            <br />
            
            
        </div>
    </div>	

	<p class="submit"><input type="submit" class="button-primary" value="Save Options" /></p>

	</form>

	</div>

	<?php
}

// Function to generate options page
function theme_ads_options() {
	global $oswc_ads;

	if ( ! isset( $_REQUEST['updated'] ) )
		$_REQUEST['updated'] = false; // This checks whether the form has just been submitted. ?>

	<?php if ( false !== $_REQUEST['updated'] ) : ?>
	<div class="updated fade"><p><strong><?php _e( 'Options saved', 'made' ); ?></strong></p></div>
	<?php endif; // If the form has just been submitted, this shows the notification ?>

	<form method="post" action="options.php">

	<?php $settings = get_option( 'oswc_ads', $oswc_ads ); ?>
	
	<?php settings_fields( 'oswc_theme_ads' );
	/* This function outputs some hidden fields required by the form,
	including a nonce, a unique number used to ensure the form has been submitted from the admin page
	and not somewhere else, very important for security */ ?>

	<div class="rm_wrap">
        <div class="rm_opts">        
        	          
            <?php //single  ?>
            <div class="rm_section">
                <div class="rm_title">
                    <h3><img src="<?php echo get_template_directory_uri(); ?>/functions/images/trans.png" class="inactive" alt="plus" /><?php _e( 'Ads that appear on all pages', 'made' ); ?></h3>
                    <span class="submit">
                        <input type="submit" value="Save Options" />
                    </span>
                    <div class="clearfix"></div>
                </div>
            
                <div class="rm_options">
        
                    <table class="form-table"><!-- Grab a hot cup of coffee, yes we're using tables! -->

                    <tr valign="top"><th scope="row"><span class="special"><label for="header_ad_hide"><?php _e( 'Hide Header Ad', 'made' ); ?></label></span></th>
                    <td>
                    <input type="checkbox" id="header_ad_hide" name="oswc_ads[header_ad_hide]" value="1" <?php checked( true, $settings['header_ad_hide'] ); ?> /> <?php _e( 'Hide the ad that appears to the right of the logo in the header area', 'made' ); ?>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><label for="header_ad"><?php _e( 'Header Ad HTML', 'made' ); ?></label></th>
                    <td>
                    <textarea id="header_ad" name="oswc_ads[header_ad]" rows="4" cols="70"><?php echo stripslashes($settings['header_ad']); ?></textarea><br />
                    <?php _e( 'The HTML for the advertisment', 'made' ); ?>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><span class="special"><label for="menu_ad_hide"><?php _e( 'Hide Menu Ad', 'made' ); ?></label></span></th>
                    <td>
                    <input type="checkbox" id="menu_ad_hide" name="oswc_ads[menu_ad_hide]" value="1" <?php checked( true, $settings['menu_ad_hide'] ); ?> /> <?php _e( 'Hide the ad that appears below the category menu', 'made' ); ?>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><label for="menu_ad"><?php _e( 'Menu Ad HTML', 'made' ); ?></label></th>
                    <td>
                    <textarea id="menu_ad" name="oswc_ads[menu_ad]" rows="4" cols="70"><?php echo stripslashes($settings['menu_ad']); ?></textarea><br />
                    <?php _e( 'The HTML for the advertisment', 'made' ); ?>
                    </td>
                    </tr> 
                                        
                    <tr valign="top"><th scope="row"><span class="special"><label for="latest_ad_hide"><?php _e( 'Hide Latest Ad', 'made' ); ?></label>;</span></th>
                    <td>
                    <input type="checkbox" id="latest_ad_hide" name="oswc_ads[latest_ad_hide]" value="1" <?php checked( true, $settings['latest_ad_hide'] ); ?> /> <?php _e( 'Hide the ad that appears below the latest slider', 'made' ); ?>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><label for="latest_ad"><?php _e( 'Latest Ad HTML', 'made' ); ?></label></th>
                    <td>
                    <textarea id="latest_ad" name="oswc_ads[latest_ad]" rows="4" cols="70"><?php echo stripslashes($settings['latest_ad']); ?></textarea><br />
                    <?php _e( 'The HTML for the advertisment', 'made' ); ?>
                    </td>
                    </tr>                    
                    
                    <tr valign="top"><th scope="row"><label for="footer_ad_hide"><?php _e( 'Hide Footer Ad', 'made' ); ?></label></th>
                    <td>
                    <input type="checkbox" id="footer_ad_hide" name="oswc_ads[footer_ad_hide]" value="1" <?php checked( true, $settings['footer_ad_hide'] ); ?> /> <?php _e( 'Hide the ad that appears above the footer', 'made' ); ?>
                    </td>
                    </tr>

                    <tr valign="top"><th scope="row"><label for="footer_ad"><?php _e( 'Footer Ad HTML', 'made' ); ?></label></th>
                    <td>
                    <textarea id="footer_ad" name="oswc_ads[footer_ad]" rows="4" cols="70"><?php echo stripslashes($settings['footer_ad']); ?></textarea><br />
                    <?php _e( 'The HTML for the advertisment', 'made' ); ?>
                    </td>
                    </tr>
                                
                    </table>
                
                </div>
            </div>    
            <br />
            
            <?php //archive  ?>
            <div class="rm_section">
                <div class="rm_title">
                    <h3><img src="<?php echo get_template_directory_uri(); ?>/functions/images/trans.png" class="inactive" alt="plus" /><?php _e( 'Ads that appear in the loop', 'made' ); ?></h3>
                    <span class="submit">
                        <input type="submit" value="Save Options" />
                    </span>
                    <div class="clearfix"></div>
                </div>
            
                <div class="rm_options">
        
                    <table class="form-table">
                    
                    <tr valign="top"><th scope="row"><label for="ad_num"><?php _e( 'Number of Ads', 'made' ); ?></label></th>
                    <td>
                    <select id="ad_num" name="oswc_ads[ad_num]">
                        <?php $i=0;
                        while ($i<=10) { ?>			
                            <option value="<?php echo $i; ?>"<?php if($settings['ad_num']==$i) { ?> selected="selected"<?php } ?>><?php echo $i; ?></option>
                        <?php $i++;
                        } ?>
                    </select>
                    <?php _e( 'Number of ads to display throughout the loop. Select "0" to hide these ads.', 'made' ); ?>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><label for="ad_increment"><?php _e( 'Increment', 'made' ); ?></label></th>
                    <td>
                    <select id="ad_increment" name="oswc_ads[ad_increment]">
                        <?php $i=2;
                        while ($i<=10) { ?>			
                            <option value="<?php echo $i; ?>"<?php if($settings['ad_increment']==$i) { ?> selected="selected"<?php } ?>><?php echo $i; ?></option>
                        <?php $i++;
                        } ?>
                    </select>
                    <?php _e( 'Display an ad every Nth post. For instance, if "3" is selected, every 3rd post will be an ad.', 'made' ); ?>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><label for="ad_offset"><?php _e( 'Off-set', 'made' ); ?></label></th>
                    <td>
                    <select id="ad_offset" name="oswc_ads[ad_offset]">
                        <?php $i=0;
                        while ($i<=10) { ?>			
                            <option value="<?php echo $i; ?>"<?php if($settings['ad_offset']==$i) { ?> selected="selected"<?php } ?>><?php echo $i; ?></option>
                        <?php $i++;
                        } ?>
                    </select>
                    <?php _e( 'Number of posts to display before the first ad', 'made' ); ?>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><label for="ad_shuffle"><?php _e( 'Shuffle', 'made' ); ?></label></th>
                    <td>
                    <input type="checkbox" id="ad_shuffle" name="oswc_ads[ad_shuffle]" value="1" <?php checked( true, $settings['ad_shuffle'] ); ?> /> <?php _e( 'Shuffle the ads to display in random order instead of the order you enter them', 'made' ); ?>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><label for="ad1"><?php _e( 'Ad 1', 'made' ); ?></label></th>
                    <td>
                    <textarea id="ad1" name="oswc_ads[ad1]" rows="4" cols="70"><?php echo stripslashes($settings['ad1']); ?></textarea><br />
                    <?php _e( 'The HTML for the advertisment', 'made' ); ?>
                    </td>
                    </tr>
                    
                	<tr valign="top"><th scope="row"><label for="ad2"><?php _e( 'Ad 2', 'made' ); ?></label></th>
                    <td>
                    <textarea id="ad2" name="oswc_ads[ad2]" rows="4" cols="70"><?php echo stripslashes($settings['ad2']); ?></textarea><br />
                    <?php _e( 'The HTML for the advertisment', 'made' ); ?>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><label for="ad3"><?php _e( 'Ad 3', 'made' ); ?></label></th>
                    <td>
                    <textarea id="ad3" name="oswc_ads[ad3]" rows="4" cols="70"><?php echo stripslashes($settings['ad3']); ?></textarea><br />
                    <?php _e( 'The HTML for the advertisment', 'made' ); ?>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><label for="ad4"><?php _e( 'Ad 4', 'made' ); ?></label></th>
                    <td>
                    <textarea id="ad4" name="oswc_ads[ad4]" rows="4" cols="70"><?php echo stripslashes($settings['ad4']); ?></textarea><br />
                    <?php _e( 'The HTML for the advertisment', 'made' ); ?>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><label for="ad5"><?php _e( 'Ad 5', 'made' ); ?></label></th>
                    <td>
                    <textarea id="ad5" name="oswc_ads[ad5]" rows="4" cols="70"><?php echo stripslashes($settings['ad5']); ?></textarea><br />
                    <?php _e( 'The HTML for the advertisment', 'made' ); ?>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><label for="ad6"><?php _e( 'Ad 6', 'made' ); ?></label></th>
                    <td>
                    <textarea id="ad6" name="oswc_ads[ad6]" rows="4" cols="70"><?php echo stripslashes($settings['ad6']); ?></textarea><br />
                    <?php _e( 'The HTML for the advertisment', 'made' ); ?>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><label for="ad7"><?php _e( 'Ad 7', 'made' ); ?></label></th>
                    <td>
                    <textarea id="ad7" name="oswc_ads[ad7]" rows="4" cols="70"><?php echo stripslashes($settings['ad7']); ?></textarea><br />
                    <?php _e( 'The HTML for the advertisment', 'made' ); ?>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><label for="ad8"><?php _e( 'Ad 8', 'made' ); ?></label></th>
                    <td>
                    <textarea id="ad8" name="oswc_ads[ad8]" rows="4" cols="70"><?php echo stripslashes($settings['ad8']); ?></textarea><br />
                    <?php _e( 'The HTML for the advertisment', 'made' ); ?>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><label for="ad9"><?php _e( 'Ad 9', 'made' ); ?></label></th>
                    <td>
                    <textarea id="ad9" name="oswc_ads[ad9]" rows="4" cols="70"><?php echo stripslashes($settings['ad9']); ?></textarea><br />
                    <?php _e( 'The HTML for the advertisment', 'made' ); ?>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><label for="ad10"><?php _e( 'Ad 10', 'made' ); ?></label></th>
                    <td>
                    <textarea id="ad10" name="oswc_ads[ad10]" rows="4" cols="70"><?php echo stripslashes($settings['ad10']); ?></textarea><br />
                    <?php _e( 'The HTML for the advertisment', 'made' ); ?>
                    </td>
                    </tr>
                    
                    </table>
                    
                </div>
            </div>    
            <br />
            
            
            <?php //more ?>
            <div class="rm_section">
                <div class="rm_title">
                    <h3><img src="<?php echo get_template_directory_uri(); ?>/functions/images/trans.png" class="inactive" alt="plus" /><?php _e( 'Ads that appear on single pages', 'made' ); ?></h3>
                    <span class="submit">
                        <input type="submit" value="Save Options" />
                    </span>
                    <div class="clearfix"></div>
                </div>
            
                <div class="rm_options">
        
                    <table class="form-table">
                    
                    <tr valign="top">
                    <td colspan="2">
                    <h3><?php _e( 'Front Page (includes review minisite front pages)', 'made' ); ?></h3>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><label for="featured_ad_hide"><?php _e( 'Hide Featured Ad', 'made' ); ?></label></th>
                    <td>
                    <input type="checkbox" id="featured_ad_hide" name="oswc_ads[featured_ad_hide]" value="1" <?php checked( true, $settings['featured_ad_hide'] ); ?> /> <?php _e( 'Hide the ad that appears below the featured slider', 'made' ); ?>
                    </td>
                    </tr>

                    <tr valign="top"><th scope="row"><label for="featured_ad"><?php _e( 'Featured Ad HTML', 'made' ); ?></label></th>
                    <td>
                    <textarea id="featured_ad" name="oswc_ads[featured_ad]" rows="4" cols="70"><?php echo stripslashes($settings['featured_ad']); ?></textarea><br />
                    <?php _e( 'The HTML for the advertisment', 'made' ); ?>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><label for="spotlight_ad_hide"><?php _e( 'Hide Spotlight Ad', 'made' ); ?></label></th>
                    <td>
                    <input type="checkbox" id="spotlight_ad_hide" name="oswc_ads[spotlight_ad_hide]" value="1" <?php checked( true, $settings['spotlight_ad_hide'] ); ?> /> <?php _e( 'Hide the ad that appears below the spotlight slider', 'made' ); ?>
                    </td>
                    </tr>

                    <tr valign="top"><th scope="row"><label for="spotlight_ad"><?php _e( 'Spotlight Ad HTML', 'made' ); ?></label></th>
                    <td>
                    <textarea id="spotlight_ad" name="oswc_ads[spotlight_ad]" rows="4" cols="70"><?php echo stripslashes($settings['spotlight_ad']); ?></textarea><br />
                    <?php _e( 'The HTML for the advertisment', 'made' ); ?>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><label for="tabs_ad_hide"><?php _e( 'Hide Tabs Ad', 'made' ); ?></label></th>
                    <td>
                    <input type="checkbox" id="tabs_ad_hide" name="oswc_ads[tabs_ad_hide]" value="1" <?php checked( true, $settings['tabs_ad_hide'] ); ?> /> <?php _e( 'Hide the ad that appears below the tabbed posts container', 'made' ); ?>
                    </td>
                    </tr>

                    <tr valign="top"><th scope="row"><label for="tabs_ad"><?php _e( 'Tabs Ad HTML', 'made' ); ?></label></th>
                    <td>
                    <textarea id="tabs_ad" name="oswc_ads[tabs_ad]" rows="4" cols="70"><?php echo stripslashes($settings['tabs_ad']); ?></textarea><br />
                    <?php _e( 'The HTML for the advertisment', 'made' ); ?>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><label for="trending_ad_hide"><?php _e( 'Hide Trending Ad', 'made' ); ?></label></th>
                    <td>
                    <input type="checkbox" id="trending_ad_hide" name="oswc_ads[trending_ad_hide]" value="1" <?php checked( true, $settings['trending_ad_hide'] ); ?> /> <?php _e( 'Hide the ad that appears below the trending slider', 'made' ); ?>
                    </td>
                    </tr>

                    <tr valign="top"><th scope="row"><label for="trending_ad"><?php _e( 'Trending Ad HTML', 'made' ); ?></label></th>
                    <td>
                    <textarea id="trending_ad" name="oswc_ads[trending_ad]" rows="4" cols="70"><?php echo stripslashes($settings['trending_ad']); ?></textarea><br />
                    <?php _e( 'The HTML for the advertisment', 'made' ); ?>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><label for="categorypanels_ad_hide"><?php _e( 'Hide Category Panels Ad', 'made' ); ?></label></th>
                    <td>
                    <input type="checkbox" id="categorypanels_ad_hide" name="oswc_ads[categorypanels_ad_hide]" value="1" <?php checked( true, $settings['categorypanels_ad_hide'] ); ?> /> <?php _e( 'Hide the ad that appears below the category panels', 'made' ); ?>
                    </td>
                    </tr>

                    <tr valign="top"><th scope="row"><label for="categorypanels_ad"><?php _e( 'Category Panels Ad HTML', 'made' ); ?></label></th>
                    <td>
                    <textarea id="categorypanels_ad" name="oswc_ads[categorypanels_ad]" rows="4" cols="70"><?php echo stripslashes($settings['categorypanels_ad']); ?></textarea><br />
                    <?php _e( 'The HTML for the advertisment', 'made' ); ?>
                    </td>
                    </tr>
                    
                    <tr valign="top">
                    <td colspan="2">
                    <h3><?php _e( 'Single Posts', 'made' ); ?></h3>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><span class="special"><label for="single_text_ad_hide"><?php _e( 'Hide Content Ad', 'made' ); ?></label></span></th>
                    <td>
                    <input type="checkbox" id="single_text_ad_hide" name="oswc_ads[single_text_ad_hide]" value="1" <?php checked( true, $settings['single_text_ad_hide'] ); ?> /> <?php _e( 'Hide the ad that appears below the post content', 'made' ); ?>
                    </td>
                    </tr>

                    <tr valign="top"><th scope="row"><label for="single_text_ad"><?php _e( 'Content Ad HTML', 'made' ); ?></label></th>
                    <td>
                    <textarea id="single_text_ad" name="oswc_ads[single_text_ad]" rows="4" cols="70"><?php echo stripslashes($settings['single_text_ad']); ?></textarea><br />
                    <?php _e( 'The HTML for the advertisment', 'made' ); ?>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><span class="special"><label for="single_comments_ad_hide"><?php _e( 'Hide Comments Ad', 'made' ); ?></label></span></th>
                    <td>
                    <input type="checkbox" id="single_comments_ad_hide" name="oswc_ads[single_comments_ad_hide]" value="1" <?php checked( true, $settings['single_comments_ad_hide'] ); ?> /> <?php _e( 'Hide the ad that appears above the comments', 'made' ); ?>
                    </td>
                    </tr>

                    <tr valign="top"><th scope="row"><label for="single_comments_ad"><?php _e( 'Comments Ad HTML', 'made' ); ?></label></th>
                    <td>
                    <textarea id="single_comments_ad" name="oswc_ads[single_comments_ad]" rows="4" cols="70"><?php echo stripslashes($settings['single_comments_ad']); ?></textarea><br />
                    <?php _e( 'The HTML for the advertisment', 'made' ); ?>
                    </td>
                    </tr>
                    
                    <tr valign="top">
                    <td colspan="2">
                    <h3><?php _e( 'Single Reviews', 'made' ); ?></h3>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><span class="special"><label for="review_overview_ad_hide"><?php _e( 'Hide Overview Ad', 'made' ); ?></label></span></th>
                    <td>
                    <input type="checkbox" id="review_overview_ad_hide" name="oswc_ads[review_overview_ad_hide]" value="1" <?php checked( true, $settings['review_overview_ad_hide'] ); ?> /> <?php _e( 'Hide the ad that appears below the review overview', 'made' ); ?>
                    </td>
                    </tr>

                    <tr valign="top"><th scope="row"><label for="review_overview_ad"><?php _e( 'Overview Ad HTML', 'made' ); ?></label></th>
                    <td>
                    <textarea id="review_overview_ad" name="oswc_ads[review_overview_ad]" rows="4" cols="70"><?php echo stripslashes($settings['review_overview_ad']); ?></textarea><br />
                    <?php _e( 'The HTML for the advertisment', 'made' ); ?>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><span class="special"><label for="review_text_ad_hide"><?php _e( 'Hide Content Ad', 'made' ); ?></label></span></th>
                    <td>
                    <input type="checkbox" id="review_text_ad_hide" name="oswc_ads[review_text_ad_hide]" value="1" <?php checked( true, $settings['review_text_ad_hide'] ); ?> /> <?php _e( 'Hide the ad that appears below the review content', 'made' ); ?>
                    </td>
                    </tr>

                    <tr valign="top"><th scope="row"><label for="review_text_ad"><?php _e( 'Content Ad HTML', 'made' ); ?></label></th>
                    <td>
                    <textarea id="review_text_ad" name="oswc_ads[review_text_ad]" rows="4" cols="70"><?php echo stripslashes($settings['review_text_ad']); ?></textarea><br />
                    <?php _e( 'The HTML for the advertisment', 'made' ); ?>
                    </td>
                    </tr>
                    
                    <tr valign="top"><th scope="row"><span class="special"><label for="review_comments_ad_hide"><?php _e( 'Hide Comments Ad', 'made' ); ?></label></span></th>
                    <td>
                    <input type="checkbox" id="review_comments_ad_hide" name="oswc_ads[review_comments_ad_hide]" value="1" <?php checked( true, $settings['review_comments_ad_hide'] ); ?> /> <?php _e( 'Hide the ad that appears above the comments', 'made' ); ?>
                    </td>
                    </tr>

                    <tr valign="top"><th scope="row"><label for="review_comments_ad"><?php _e( 'Comments Ad HTML', 'made' ); ?></label></th>
                    <td>
                    <textarea id="review_comments_ad" name="oswc_ads[review_comments_ad]" rows="4" cols="70"><?php echo stripslashes($settings['review_comments_ad']); ?></textarea><br />
                    <?php _e( 'The HTML for the advertisment', 'made' ); ?>
                    </td>
                    </tr>
                                        
                    </table>
                    
                </div>
            </div>    
            <br />
            
        </div>
    </div>	

	<p class="submit"><input type="submit" class="button-primary" value="Save Options" /></p>

	</form>

	</div>

	<?php
}


// Function to generate options page
function theme_bp_options() {
	global $oswc_bp;

	if ( ! isset( $_REQUEST['updated'] ) )
		$_REQUEST['updated'] = false; // This checks whether the form has just been submitted. ?>

	<?php if ( false !== $_REQUEST['updated'] ) : ?>
	<div class="updated fade"><p><strong><?php _e( 'Options saved', 'made' ); ?></strong></p></div>
	<?php endif; // If the form has just been submitted, this shows the notification ?>

	<form method="post" action="options.php">

	<?php $settings = get_option( 'oswc_bp', $oswc_bp ); ?>
	
	<?php settings_fields( 'oswc_theme_bp' );
	/* This function outputs some hidden fields required by the form,
	including a nonce, a unique number used to ensure the form has been submitted from the admin page
	and not somewhere else, very important for security */ ?>
    
    <p class="submit"><input type="submit" class="button-primary" value="Save Options" /></p>

	<table class="form-table"><!-- Grab a hot cup of coffee, yes we're using tables! -->
    
    <tr valign="top"><th scope="row"><?php _e( 'Unique BuddyPress Sidebar', 'made' ); ?></th>
    <td>
    <input type="checkbox" id="bp_sidebar_unique" name="oswc_bp[bp_sidebar_unique]" value="1" <?php checked( true, $settings['bp_sidebar_unique'] ); ?> /> <label for="bp_sidebar_unique"><?php _e( 'Use the BuddyPress Default Sidebar widget panel for all BuddyPress pages. This can be overwritten by the settings below for individual sections of BuddyPress.', 'made' ); ?></label>
    </td>
    </tr>
    
    <tr valign="top"><th scope="row"><?php _e( 'Unique Activity Sidebar', 'made' ); ?></th>
    <td>
    <input type="checkbox" id="bp_activity_sidebar_unique" name="oswc_bp[bp_activity_sidebar_unique]" value="1" <?php checked( true, $settings['bp_activity_sidebar_unique'] ); ?> /> <label for="bp_activity_sidebar_unique"><?php _e( 'Use the BuddyPress Activity Sidebar widget panel for all BuddyPress Activity pages.', 'made' ); ?></label>
    </td>
    </tr>
    
    <tr valign="top"><th scope="row"><?php _e( 'Unique Members Sidebar', 'made' ); ?></th>
    <td>
    <input type="checkbox" id="bp_members_sidebar_unique" name="oswc_bp[bp_members_sidebar_unique]" value="1" <?php checked( true, $settings['bp_members_sidebar_unique'] ); ?> /> <label for="bp_members_sidebar_unique"><?php _e( 'Use the BuddyPress Members Sidebar widget panel for all BuddyPress Members pages.', 'made' ); ?></label>
    </td>
    </tr>
    
    <tr valign="top"><th scope="row"><?php _e( 'Unique Groups Sidebar', 'made' ); ?></th>
    <td>
    <input type="checkbox" id="bp_groups_sidebar_unique" name="oswc_bp[bp_groups_sidebar_unique]" value="1" <?php checked( true, $settings['bp_groups_sidebar_unique'] ); ?> /> <label for="bp_groups_sidebar_unique"><?php _e( 'Use the BuddyPress Groups Sidebar widget panel for all BuddyPress Groups pages.', 'made' ); ?></label>
    </td>
    </tr>
    
    <tr valign="top"><th scope="row"><?php _e( 'Unique Forums Sidebar', 'made' ); ?></th>
    <td>
    <input type="checkbox" id="bp_forums_sidebar_unique" name="oswc_bp[bp_forums_sidebar_unique]" value="1" <?php checked( true, $settings['bp_forums_sidebar_unique'] ); ?> /> <label for="bp_forums_sidebar_unique"><?php _e( 'Use the BuddyPress Forums Sidebar widget panel for all BuddyPress Forums pages.', 'made' ); ?></label>
    </td>
    </tr>
    
    <tr valign="top"><th scope="row"><?php _e( 'Unique Blogs Sidebar', 'made' ); ?></th>
    <td>
    <input type="checkbox" id="bp_blogs_sidebar_unique" name="oswc_bp[bp_blogs_sidebar_unique]" value="1" <?php checked( true, $settings['bp_blogs_sidebar_unique'] ); ?> /> <label for="bp_blogs_sidebar_unique"><?php _e( 'Use the BuddyPress Blogs Sidebar widget panel for all BuddyPress Blogs pages.', 'made' ); ?></label>
    </td>
    </tr>
    
    <tr valign="top"><th scope="row"><?php _e( 'Unique Registration Sidebar', 'made' ); ?></th>
    <td>
    <input type="checkbox" id="bp_registration_sidebar_unique" name="oswc_bp[bp_registration_sidebar_unique]" value="1" <?php checked( true, $settings['bp_registration_sidebar_unique'] ); ?> /> <label for="bp_registration_sidebar_unique"><?php _e( 'Use the BuddyPress Registration Sidebar widget panel for all BuddyPress Registration pages.', 'made' ); ?></label>
    </td>
    </tr>
    
	</table>

	<p class="submit"><input type="submit" class="button-primary" value="Save Options" /></p>

	</form>

	</div>

	<?php
}

// Function to generate options page
function theme_misc_options() {
	global $oswc_misc;

	if ( ! isset( $_REQUEST['updated'] ) )
		$_REQUEST['updated'] = false; // This checks whether the form has just been submitted. ?>

	<?php if ( false !== $_REQUEST['updated'] ) : ?>
	<div class="updated fade"><p><strong><?php _e( 'Options saved', 'made' ); ?></strong></p></div>
	<?php endif; // If the form has just been submitted, this shows the notification ?>

	<form method="post" action="options.php">

	<?php $settings = get_option( 'oswc_misc', $oswc_misc ); ?>
	
	<?php settings_fields( 'oswc_theme_misc' );
	/* This function outputs some hidden fields required by the form,
	including a nonce, a unique number used to ensure the form has been submitted from the admin page
	and not somewhere else, very important for security */ ?>
    
    <p class="submit"><input type="submit" class="button-primary" value="Save Options" /></p>

	<table class="form-table"><!-- Grab a hot cup of coffee, yes we're using tables! -->

	<tr valign="top"><th scope="row"><label for="background"><?php _e( 'Site Background', 'made' ); ?></label></th>
	<td>
	<select id="background" name="oswc_misc[background]">
       	<option value="none.png"<?php if($settings['background']=='none.png') { ?> selected="selected"<?php } ?>><?php _e( 'None', 'made' ); ?></option>
        <option value="texture-brick1.png"<?php if($settings['background']=='texture-brick1.png') { ?> selected="selected"<?php } ?>><?php _e( 'Texture Brick 1', 'made' ); ?></option>
        <option value="texture-brick2.png"<?php if($settings['background']=='texture-brick2.png') { ?> selected="selected"<?php } ?>><?php _e( 'Texture Brick 2', 'made' ); ?></option>
        <option value="texture-brick3.png"<?php if($settings['background']=='texture-brick3.png') { ?> selected="selected"<?php } ?>><?php _e( 'Texture Brick 3', 'made' ); ?></option>
        <option value="texture-brick4.png"<?php if($settings['background']=='texture-brick4.png') { ?> selected="selected"<?php } ?>><?php _e( 'Texture Brick 4', 'made' ); ?></option>
        
        <option value="texture-wood1.png"<?php if($settings['background']=='texture-wood1.png') { ?> selected="selected"<?php } ?>><?php _e( 'Texture Wood 1', 'made' ); ?></option>
        <option value="texture-wood2.png"<?php if($settings['background']=='texture-wood2.png') { ?> selected="selected"<?php } ?>><?php _e( 'Texture Wood 2', 'made' ); ?></option>
        <option value="texture-wood3.png"<?php if($settings['background']=='texture-wood3.png') { ?> selected="selected"<?php } ?>><?php _e( 'Texture Wood 3', 'made' ); ?></option>
        <option value="texture-wood4.png"<?php if($settings['background']=='texture-wood4.png') { ?> selected="selected"<?php } ?>><?php _e( 'Texture Wood 4', 'made' ); ?></option>
        
        <option value="texture-metal1.png"<?php if($settings['background']=='texture-metal1.png') { ?> selected="selected"<?php } ?>><?php _e( 'Texture Metal 1', 'made' ); ?></option>
        <option value="texture-metal2.png"<?php if($settings['background']=='texture-metal2.png') { ?> selected="selected"<?php } ?>><?php _e( 'Texture Metal 2', 'made' ); ?></option>
        <option value="texture-metal3.png"<?php if($settings['background']=='texture-metal3.png') { ?> selected="selected"<?php } ?>><?php _e( 'Texture Metal 3', 'made' ); ?></option>
        <option value="texture-leaf1.png"<?php if($settings['background']=='texture-leaf1.png') { ?> selected="selected"<?php } ?>><?php _e( 'Texture Leaf', 'made' ); ?></option>
        
        <option value="texture-pave1.png"<?php if($settings['background']=='texture-pave1.png') { ?> selected="selected"<?php } ?>><?php _e( 'Texture Pave 1', 'made' ); ?></option>
        <option value="texture-pave2.png"<?php if($settings['background']=='texture-pave2.png') { ?> selected="selected"<?php } ?>><?php _e( 'Texture Pave 2', 'made' ); ?></option>
        <option value="texture-pave3.png"<?php if($settings['background']=='texture-pave3.png') { ?> selected="selected"<?php } ?>><?php _e( 'Texture Pave 3', 'made' ); ?></option>
        <option value="texture-pave4.png"<?php if($settings['background']=='texture-pave4.png') { ?> selected="selected"<?php } ?>><?php _e( 'Texture Pave 4', 'made' ); ?></option>
        <option value="texture-pave5.png"<?php if($settings['background']=='texture-pave5.png') { ?> selected="selected"<?php } ?>><?php _e( 'Texture Pave 5', 'made' ); ?></option>
        
        <option value="texture-rock1.png"<?php if($settings['background']=='texture-rock1.png') { ?> selected="selected"<?php } ?>><?php _e( 'Texture Rock 1', 'made' ); ?></option>
        <option value="texture-rock2.png"<?php if($settings['background']=='texture-rock2.png') { ?> selected="selected"<?php } ?>><?php _e( 'Texture Rock 2', 'made' ); ?></option>
        <option value="texture-rock3.png"<?php if($settings['background']=='texture-rock3.png') { ?> selected="selected"<?php } ?>><?php _e( 'Texture Rock 3', 'made' ); ?></option>
        <option value="texture-surface1.png"<?php if($settings['background']=='texture-surface1.png') { ?> selected="selected"<?php } ?>><?php _e( 'Texture Surface', 'made' ); ?></option>
        
        <option value="texture-wallpaper1.png"<?php if($settings['background']=='texture-wallpaper1.png') { ?> selected="selected"<?php } ?>><?php _e( 'Texture Wallpaper 1', 'made' ); ?></option>
        <option value="texture-wallpaper2.png"<?php if($settings['background']=='texture-wallpaper2.png') { ?> selected="selected"<?php } ?>><?php _e( 'Texture Wallpaper 2', 'made' ); ?></option>
        
        <option value="texture-textile1.png"<?php if($settings['background']=='texture-textile1.png') { ?> selected="selected"<?php } ?>><?php _e( 'Texture Textile 1', 'made' ); ?></option>
        <option value="texture-textile2.png"<?php if($settings['background']=='texture-textile2.png') { ?> selected="selected"<?php } ?>><?php _e( 'Texture Textile 2', 'made' ); ?></option>
        <option value="texture-textile3.png"<?php if($settings['background']=='texture-textile3.png') { ?> selected="selected"<?php } ?>><?php _e( 'Texture Textile 3', 'made' ); ?></option>
        <option value="texture-textile4.png"<?php if($settings['background']=='texture-textile4.png') { ?> selected="selected"<?php } ?>><?php _e( 'Texture Textile 4', 'made' ); ?></option>
        <option value="texture-textile5.png"<?php if($settings['background']=='texture-textile5.png') { ?> selected="selected"<?php } ?>><?php _e( 'Texture Textile 5', 'made' ); ?></option>
        
        <option value="blur-1.jpg"<?php if($settings['background']=='blur-1.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Blur 1', 'made' ); ?></option>
        <option value="blur-2.jpg"<?php if($settings['background']=='blur-2.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Blur 2', 'made' ); ?></option>
        <option value="blur-3.jpg"<?php if($settings['background']=='blur-3.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Blur 3', 'made' ); ?></option>
        <option value="blur-4.jpg"<?php if($settings['background']=='blur-4.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Blur 4', 'made' ); ?></option>
        <option value="blur-5.jpg"<?php if($settings['background']=='blur-5.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Blur 5', 'made' ); ?></option>
        <option value="blur-6.jpg"<?php if($settings['background']=='blur-6.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Blur 6', 'made' ); ?></option>
        <option value="blur-7.jpg"<?php if($settings['background']=='blur-7.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Blur 7', 'made' ); ?></option>
        <option value="blur-8.jpg"<?php if($settings['background']=='blur-8.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Blur 8', 'made' ); ?></option>
        <option value="blur-9.jpg"<?php if($settings['background']=='blur-9.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Blur 9', 'made' ); ?></option>
        <option value="blur-10.jpg"<?php if($settings['background']=='blur-10.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Blur 10', 'made' ); ?></option>
        <option value="blur-11.jpg"<?php if($settings['background']=='blur-11.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Blur 11', 'made' ); ?></option>
        <option value="blur-12.jpg"<?php if($settings['background']=='blur-12.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Blur 12', 'made' ); ?></option>
        <option value="blur-13.jpg"<?php if($settings['background']=='blur-13.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Blur 13', 'made' ); ?></option>
        <option value="blur-14.jpg"<?php if($settings['background']=='blur-14.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Blur 14', 'made' ); ?></option>
        <option value="blur-15.jpg"<?php if($settings['background']=='blur-15.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Blur 15', 'made' ); ?></option>
        <option value="blur-16.jpg"<?php if($settings['background']=='blur-16.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Blur 16', 'made' ); ?></option>
        <option value="blur-17.jpg"<?php if($settings['background']=='blur-17.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Blur 17', 'made' ); ?></option>
        <option value="blur-18.jpg"<?php if($settings['background']=='blur-18.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Blur 18', 'made' ); ?></option>
        <option value="blur-19.jpg"<?php if($settings['background']=='blur-19.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Blur 19', 'made' ); ?></option>
        <option value="blur-20.jpg"<?php if($settings['background']=='blur-20.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Blur 20', 'made' ); ?></option>
        <option value="blur-21.jpg"<?php if($settings['background']=='blur-21.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Blur 21', 'made' ); ?></option>
        <option value="blur-22.jpg"<?php if($settings['background']=='blur-22.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Blur 22', 'made' ); ?></option>
        <option value="blur-23.jpg"<?php if($settings['background']=='blur-23.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Blur 23', 'made' ); ?></option>
        <option value="blur-24.jpg"<?php if($settings['background']=='blur-24.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Blur 24', 'made' ); ?></option>
        <option value="blur-25.jpg"<?php if($settings['background']=='blur-25.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Blur 25', 'made' ); ?></option>
        <option value="blur-26.jpg"<?php if($settings['background']=='blur-26.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Blur 26', 'made' ); ?></option>
        <option value="blur-27.jpg"<?php if($settings['background']=='blur-27.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Blur 27', 'made' ); ?></option>
        <option value="blur-28.jpg"<?php if($settings['background']=='blur-28.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Blur 28', 'made' ); ?></option>
        <option value="blur-29.jpg"<?php if($settings['background']=='blur-29.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Blur 29', 'made' ); ?></option>
        <option value="blur-30.jpg"<?php if($settings['background']=='blur-30.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Blur 30', 'made' ); ?></option>
        <option value="blur-31.jpg"<?php if($settings['background']=='blur-31.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Blur 31', 'made' ); ?></option>
        
        <option value="grunge-1.jpg"<?php if($settings['background']=='grunge-1.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Grunge 1', 'made' ); ?></option>
        <option value="grunge-2.jpg"<?php if($settings['background']=='grunge-2.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Grunge 2', 'made' ); ?></option>
        <option value="grunge-3.jpg"<?php if($settings['background']=='grunge-3.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Grunge 3', 'made' ); ?></option>
        <option value="grunge-4.jpg"<?php if($settings['background']=='grunge-4.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Grunge 4', 'made' ); ?></option>  
        <option value="vintage-wallpaper-black.jpg"<?php if($settings['background']=='vintage-wallpaper-black.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Vintage Wallpaper Black', 'made' ); ?></option> 
        <option value="vintage-wallpaper-blue.jpg"<?php if($settings['background']=='vintage-wallpaper-blue.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Vintage Wallpaper Blue', 'made' ); ?></option> 
        <option value="vintage-wallpaper-brown.jpg"<?php if($settings['background']=='vintage-wallpaper-brown.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Vintage Wallpaper Brown', 'made' ); ?></option> 
        <option value="vintage-wallpaper-green.jpg"<?php if($settings['background']=='vintage-wallpaper-green.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Vintage Wallpaper Green', 'made' ); ?></option> 
        <option value="vintage-wallpaper-red.jpg"<?php if($settings['background']=='vintage-wallpaper-red.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Vintage Wallpaper Red', 'made' ); ?></option> 
        <option value="vintage-wallpaper-purple.jpg"<?php if($settings['background']=='vintage-wallpaper-purple.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Vintage Wallpaper Purple', 'made' ); ?></option> 
        <option value="vintage-wallpaper-gold.jpg"<?php if($settings['background']=='vintage-wallpaper-gold.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Vintage Wallpaper Gold', 'made' ); ?></option> 
        <option value="vintage-wallpaper-light.jpg"<?php if($settings['background']=='vintage-wallpaper-light.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Vintage Wallpaper Light', 'made' ); ?></option> 
        <option value="wave-rays-blue.jpg"<?php if($settings['background']=='wave-rays-blue.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Wave Blue', 'made' ); ?></option>
        <option value="wave-rays-blue-grey.jpg"<?php if($settings['background']=='wave-rays-blue-grey.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Wave Blue/Grey', 'made' ); ?></option>
        <option value="wave-rays-green.jpg"<?php if($settings['background']=='wave-rays-green.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Wave Green', 'made' ); ?></option>
        <option value="wave-rays-green-yellow.jpg"<?php if($settings['background']=='wave-rays-green-yellow.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Wave Green/Yellow', 'made' ); ?></option>
        <option value="wave-rays-orange-green.jpg"<?php if($settings['background']=='wave-rays-orange-green.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Wave Orange/Green', 'made' ); ?></option>
        <option value="wave-rays-purple.jpg"<?php if($settings['background']=='wave-rays-purple.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Wave Purple', 'made' ); ?></option>
        <option value="wave-rays-purple-orange.jpg"<?php if($settings['background']=='wave-rays-purple-orange.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Wave Purple/Orange', 'made' ); ?></option>
        <option value="wave-rays-purple-red.jpg"<?php if($settings['background']=='wave-rays-purple-red.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Wave Purple/Red', 'made' ); ?></option>
        <option value="wave-rays-pink.jpg"<?php if($settings['background']=='wave-rays-pink.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Wave Pink', 'made' ); ?></option>
        <option value="wave-grunge-blue.jpg"<?php if($settings['background']=='wave-grunge-blue.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Wave Blue (Grunge)', 'made' ); ?></option>
        <option value="wave-grunge-blue-grey.jpg"<?php if($settings['background']=='wave-grunge-blue-grey.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Wave Blue/Grey (Grunge)', 'made' ); ?></option>
        <option value="wave-grunge-green.jpg"<?php if($settings['background']=='wave-grunge-green.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Wave Green (Grunge)', 'made' ); ?></option>
        <option value="wave-grunge-green-yellow.jpg"<?php if($settings['background']=='wave-grunge-green-yellow.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Wave Green/Yellow (Grunge)', 'made' ); ?></option>
        <option value="wave-grunge-orange-green.jpg"<?php if($settings['background']=='wave-grunge-orange-green.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Wave Orange/Green (Grunge)', 'made' ); ?></option>
        <option value="wave-grunge-purple.jpg"<?php if($settings['background']=='wave-grunge-purple.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Wave Purple (Grunge)', 'made' ); ?></option>
        <option value="wave-grunge-purple-orange.jpg"<?php if($settings['background']=='wave-grunge-purple-orange.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Wave Purple/Orange (Grunge)', 'made' ); ?></option>
        <option value="wave-grunge-purple-red.jpg"<?php if($settings['background']=='wave-grunge-purple-red.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Wave Purple/Red (Grunge)', 'made' ); ?></option>
        <option value="wave-grunge-pink.jpg"<?php if($settings['background']=='wave-grunge-pink.jpg') { ?> selected="selected"<?php } ?>><?php _e( 'Wave Pink (Grunge)', 'made' ); ?></option>          
	</select> <?php _e( 'Note: textures are transparent so that you can combine them with any background color (Appearance >> Background)','made'); ?>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><?php _e( 'Fixed Background Image', 'made' ); ?></th>
    <td>
    <input type="checkbox" id="background_fixed" name="oswc_misc[background_fixed]" value="1" <?php checked( true, $settings['background_fixed'] ); ?> /> <label for="background_fixed"><?php _e( 'Fix the background image so that it does not move when you scroll the page', 'made' ); ?></label>
    </td>
    </tr>
    
    <tr valign="top"><th scope="row"><label for="logo"><?php _e( 'Logo URL', 'made' ); ?></label></th>
	<td>
	<textarea id="logo" name="oswc_misc[logo]" rows="2" cols="75"><?php echo stripslashes($settings['logo']); ?></textarea><br />
    <?php _e( 'The URL of your logo image. You can use the Media >> Add New screen to upload your logo. Copy + Paste the URL of your uploaded logo here.', 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="logo_iphone"><?php _e( 'Logo URL (mobile)', 'made' ); ?></label></th>
	<td>
	<textarea id="logo_iphone" name="oswc_misc[logo_iphone]" rows="2" cols="75"><?php echo stripslashes($settings['logo_iphone']); ?></textarea><br />
    <?php _e( 'The URL of your logo image to be used on mobile devices for responsive purposes. This should be no wider than about 300px. You can use the Media >> Add New screen to upload your logo. Copy + Paste the URL of your uploaded logo here.', 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="logo_ipad"><?php _e( 'Logo URL (tablets)', 'made' ); ?></label></th>
	<td>
	<textarea id="logo_ipad" name="oswc_misc[logo_ipad]" rows="2" cols="75"><?php echo stripslashes($settings['logo_ipad']); ?></textarea><br />
    <?php _e( 'The URL of your logo image to be used on tablets for responsive purposes. This should be no wider than about 720px. You can use the Media >> Add New screen to upload your logo. Copy + Paste the URL of your uploaded logo here.', 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><?php _e( 'Skin', 'made' ); ?></th>
	<td>
	<input type="radio" id="skin_light" name="oswc_misc[skin]" value="light" <?php checked( $settings['skin'], "light" ); ?> />
    <label for="skin_light"><?php _e('Light','made'); ?></label>    
    <input type="radio" id="skin_dark" name="oswc_misc[skin]" value="dark" <?php checked( $settings['skin'], "dark" ); ?> />
    <label for="skin_dark"><?php _e('Dark','made'); ?></label> <br /> 
    <?php _e( 'The skin can be light or dark, and affects all pages but can be overwritten on a review type basis.', 'made' ); ?>
	</td>
	</tr> 
    
    <tr valign="top"><th scope="row"><label for="color_scheme"><?php _e( 'Main Color Scheme', 'made' ); ?></label></th>
    <td>
    <div style="float:left;">
        #<input id="color_scheme" name="oswc_misc[color_scheme]" type="text" value="<?php esc_attr_e($settings['color_scheme']); ?>" style="width:80px;" />
    </div>
    <div class="color_preview_wrapper">
        <div id="color_scheme_preview" class="color_scheme_preview" style="background-color:#<?php esc_attr_e($settings['color_scheme']); ?>;">&nbsp;</div>
    </div>

    <br class="clearer" />

    <?php _e('The main color scheme that applies mainly to the logo bar background.','made'); ?>
    </td>
    </tr>  
    
    <tr valign="top"><th scope="row"><label for="logo_bar_image"><?php _e( 'Logo Bar BG Image URL', 'made' ); ?></label></th>
    <td>
    <textarea id="logo_bar_image" name="oswc_misc[logo_bar_image]" rows="2" cols="90"><?php echo stripslashes($settings['logo_bar_image']); ?></textarea><br />
    <?php _e( 'The URL of the logo bar background image (leave blank to use the color scheme as the background for the logo bar)', 'made' ); ?>
    </td>
    </tr>
    
    <tr valign="top"><th scope="row"><?php _e( 'Hide Logo Bar Background', 'made' ); ?></th>
    <td>
    <input type="checkbox" id="hide_logo_bar_bg" name="oswc_misc[hide_logo_bar_bg]" value="1" <?php checked( true, $settings['hide_logo_bar_bg'] ); ?> />
    <label for="hide_logo_bar_bg"><?php _e( 'Do not display anything for the background of the logo bar, regardless of what is specified above for the color scheme and logo bar bg image url. This is handy if you want to let your main background image show through in the logo bar area.', 'made' ); ?></label>
    </td>
    </tr> 
    
    <tr valign="top"><th scope="row"><?php _e( 'Responsive Tablets', 'made' ); ?></th>
    <td>
    <input type="checkbox" id="responsive_tablet" name="oswc_misc[responsive_tablet]" value="1" <?php checked( true, $settings['responsive_tablet'] ); ?> /> <label for="responsive_tablet"><?php _e( 'The theme should respond when viewed on tablets and display a different layout appropriate to tablet screen sizes', 'made' ); ?></label>
    </td>
    </tr>
    
    <tr valign="top"><th scope="row"><?php _e( 'Responsive Phones', 'made' ); ?></th>
    <td>
    <input type="checkbox" id="responsive_phone" name="oswc_misc[responsive_phone]" value="1" <?php checked( true, $settings['responsive_phone'] ); ?> /> <label for="responsive_phone"><?php _e( 'The theme should respond when viewed on smart phones and display a different layout appropriate to smart phone screen sizes', 'made' ); ?></label>
    </td>
    </tr>
    
    <tr valign="top">
	<td colspan="2">
	<h3><?php _e( "Don't Miss Bar", 'made' ); ?></h3>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><span class="special"><?php _e( 'Hide', 'made' ); ?></span></th>
    <td>
    <input type="checkbox" id="dontmiss_hide" name="oswc_misc[dontmiss_hide]" value="1" <?php checked( true, $settings['dontmiss_hide'] ); ?> /> <label for="dontmiss_hide"><?php _e( "Hide the Don't Miss Bar at the top of all pages", 'made' ); ?></label>
    </td>
    </tr>
    
    <tr valign="top"><th scope="row"><label for="dontmiss_header"><?php _e( 'Header Text', 'made' ); ?></label></th>
	<td>
	<input id="dontmiss_header" name="oswc_misc[dontmiss_header]" type="text" value="<?php esc_attr_e($settings['dontmiss_header']); ?>" />
    <?php _e( "The header text that displays to at the very left of the Don't Miss bar.", 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><span class="special"><?php _e( 'Scroll', 'made' ); ?></span></th>
    <td>
    <input type="checkbox" id="dontmiss_scroll" name="oswc_misc[dontmiss_scroll]" value="1" <?php checked( true, $settings['dontmiss_scroll'] ); ?> /> <label for="dontmiss_scroll"><?php _e( "The Don't Miss slider should scroll from right to left. If this is disabled, the Don't Miss bar will display only two articles.", 'made' ); ?></label>
    </td>
    </tr>
    
    <tr valign="top"><th scope="row"><label for="dontmiss_num"><?php _e( 'Number of Slides', 'made' ); ?></label></th>
	<td>
	<select id="dontmiss_num" name="oswc_misc[dontmiss_num]">
    	<?php $i=5;
		while ($i<=30) { ?>			
    		<option value="<?php echo $i; ?>"<?php if($settings['dontmiss_num']==$i) { ?> selected="selected"<?php } ?>><?php echo $i; ?></option>
        <?php $i++;
		} ?>
	</select><br />
    <?php _e( 'Number of slides to rotate through. Make sure you actually have this many posts tagged (or in the assigned category or review) or else the style will not display correctly.', 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="dontmiss_type"><?php _e( 'Type of Posts', 'made' ); ?></label></th>
	<td>
	<select id="dontmiss_type" name="oswc_misc[dontmiss_type]">    			
    	<option value="tag"<?php if($settings['dontmiss_type']=='tag') { ?> selected="selected"<?php } ?>><?php _e( 'Tag','made'); ?></option>  
        <option value="category"<?php if($settings['dontmiss_type']=='category') { ?> selected="selected"<?php } ?>><?php _e( 'Category','made'); ?></option> 
        <option value="review"<?php if($settings['dontmiss_type']=='review') { ?> selected="selected"<?php } ?>><?php _e( 'Review Type','made'); ?></option> 
        <option value="latest"<?php if($settings['dontmiss_type']=='latest') { ?> selected="selected"<?php } ?>><?php _e( 'Latest Articles','made'); ?></option>         
	</select>
    <?php _e( 'The type of posts to look for to populate the slider', 'made' ); ?>
	</td>
	</tr> 
    
    <tr valign="top"><th scope="row"><label for="latest_tag"><?php _e( "Don't Miss Term", 'made' ); ?></label></th>
	<td>
	<input id="dontmiss_tag" name="oswc_misc[dontmiss_tag]" type="text" value="<?php esc_attr_e($settings['dontmiss_tag']); ?>" />
    <?php _e( "Name of the term to use to find articles for the Don't Miss slider. If the type is Tag, enter the tag name. If the type is Category, enter the category name. And if the type is Review, enter the name of the review type.", 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="dontmiss_email_header"><?php _e( 'Signup Header Text', 'made' ); ?></label></th>
	<td>
	<input id="dontmiss_email_header" name="oswc_misc[dontmiss_email_header]" type="text" value="<?php esc_attr_e($settings['dontmiss_email_header']); ?>" />
    <?php _e( "The header text that displays above the Signup form on the right of the Don't Miss bar.", 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="dontmiss_widget_type"><?php _e( 'Signup Widget Type', 'made' ); ?></label></th>
	<td>
	<select id="dontmiss_widget_type" name="oswc_misc[dontmiss_widget_type]">    			
    	<option value="Signup"<?php if($settings['dontmiss_widget_type']=='Signup') { ?> selected="selected"<?php } ?>><?php _e( 'Signup Form','made'); ?></option>  
        <option value="Social"<?php if($settings['dontmiss_widget_type']=='Social') { ?> selected="selected"<?php } ?>><?php _e( 'Social Media Buttons','made'); ?></option> 
        <option value="Widget"<?php if($settings['dontmiss_widget_type']=='Widget') { ?> selected="selected"<?php } ?>><?php _e( 'Widget','made'); ?></option>          
	</select>
    <?php _e( 'Type of content to display in the signup area on the right. If Widget is selected, put a widget into the Signup Widget widget panel in Appearance >> Widgets', 'made' ); ?>
	</td>
	</tr> 
    
    <tr valign="top">
	<td colspan="2">
	<h3><?php _e( 'Latest Slider', 'made' ); ?></h3>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><span class="special"><?php _e( 'Hide', 'made' ); ?></span></th>
    <td>
    <input type="checkbox" id="latest_hide" name="oswc_misc[latest_hide]" value="1" <?php checked( true, $settings['latest_hide'] ); ?> /> <label for="latest_hide"><?php _e( 'Hide the Latest Slider at the top of all pages', 'made' ); ?></label>
    </td>
    </tr>
    
    <tr valign="top"><th scope="row"><label for="latest_num"><?php _e( 'Number of Slides', 'made' ); ?></label></th>
	<td>
	<select id="latest_num" name="oswc_misc[latest_num]">
    	<?php $i=4;
		while ($i<=30) { ?>			
    		<option value="<?php echo $i; ?>"<?php if($settings['latest_num']==$i) { ?> selected="selected"<?php } ?>><?php echo $i; ?></option>
        <?php $i++;
		} ?>
	</select><br />
    <?php _e( 'Number of slides to rotate through. Make sure you actually have this many posts tagged (or in the assigned category or review) or else the style will not display correctly.', 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="latest_type"><?php _e( 'Type of Posts', 'made' ); ?></label></th>
	<td>
	<select id="latest_type" name="oswc_misc[latest_type]">    			
    	<option value="tag"<?php if($settings['latest_type']=='tag') { ?> selected="selected"<?php } ?>><?php _e( 'Tag','made'); ?></option>  
        <option value="category"<?php if($settings['latest_type']=='category') { ?> selected="selected"<?php } ?>><?php _e( 'Category','made'); ?></option> 
        <option value="review"<?php if($settings['latest_type']=='review') { ?> selected="selected"<?php } ?>><?php _e( 'Review Type','made'); ?></option> 
        <option value="latest"<?php if($settings['latest_type']=='latest') { ?> selected="selected"<?php } ?>><?php _e( 'Latest Articles','made'); ?></option>         
	</select>
    <?php _e( 'The type of posts to look for to populate the slider', 'made' ); ?>
	</td>
	</tr> 
    
    <tr valign="top"><th scope="row"><label for="latest_tag"><?php _e( 'Latest Term', 'made' ); ?></label></th>
	<td>
	<input id="latest_tag" name="oswc_misc[latest_tag]" type="text" value="<?php esc_attr_e($settings['latest_tag']); ?>" />
    <?php _e( "Name of the term to use to find articles for the Latest slider. If the type is Tag, enter the tag name. If the type is Category, enter the category name. And if the type is Review, enter the name of the review type.", 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top">
	<td colspan="2">
	<h3><?php _e( 'More Options', 'made' ); ?></h3>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><?php _e( 'Show Top Widget', 'made' ); ?></th>
    <td>
    <input type="checkbox" id="top_widget_show" name="oswc_misc[top_widget_show]" value="1" <?php checked( true, $settings['top_widget_show'] ); ?> /> <label for="top_widget_show"><?php _e( 'Show the top widget area that appears left of the search box which displays social media buttons by default', 'made' ); ?></label>
    </td>
    </tr>
    
    <tr valign="top"><th scope="row"><?php _e( 'Show Search Form', 'made' ); ?></th>
    <td>
    <input type="checkbox" id="search_show" name="oswc_misc[search_show]" value="1" <?php checked( true, $settings['search_show'] ); ?> /> <label for="search_show"><?php _e( 'Show the search form in the top menu bar', 'made' ); ?></label>
    </td>
    </tr>
    
    <tr valign="top"><th scope="row"><?php _e( 'Show Random Button', 'made' ); ?></th>
    <td>
    <input type="checkbox" id="random_show" name="oswc_misc[random_show]" value="1" <?php checked( true, $settings['random_show'] ); ?> /> <label for="random_show"><?php _e( 'Show the random button to the right of the category menu', 'made' ); ?></label>
    </td>
    </tr>
    
    <tr valign="top"><th scope="row"><?php _e( 'Hide Sub Menu', 'made' ); ?></th>
    <td>
    <input type="checkbox" id="sub_menu_hide" name="oswc_misc[sub_menu_hide]" value="1" <?php checked( true, $settings['sub_menu_hide'] ); ?> /> <label for="sub_menu_hide"><?php _e( 'Hide the sub menu which appears directly the main menu (does not hide the taxonomy menu for review mini-sites)', 'made' ); ?></label>
    </td>
    </tr>
    
    <tr valign="top"><th scope="row"><?php _e( 'Hide Footer Menu', 'made' ); ?></th>
    <td>
    <input type="checkbox" id="footer_menu_hide" name="oswc_misc[footer_menu_hide]" value="1" <?php checked( true, $settings['footer_menu_hide'] ); ?> /> <label for="footer_menu_hide"><?php _e( 'Hide the footer menu which appears directly above the footer below the page content', 'made' ); ?></label>
    </td>
    </tr>
    
    <tr valign="top"><th scope="row"><?php _e( 'Colorbox Enabled', 'made' ); ?></th>
    <td>
    <input type="checkbox" id="colorbox" name="oswc_misc[colorbox]" value="1" <?php checked( true, $settings['colorbox'] ); ?> /> <label for="colorbox"><?php _e( 'Enable the colorbox jQuery plugin', 'made' ); ?></label>
    </td>
    </tr>
    
    <tr valign="top"><th scope="row"><?php _e( 'Show Demo Panel', 'made' ); ?></th>
    <td>
    <input type="checkbox" id="demo" name="oswc_misc[demo]" value="1" <?php checked( true, $settings['demo'] ); ?> /> <label for="demo"><?php _e( 'Show the demo settings panel', 'made' ); ?></label>
    </td>
    </tr>
    
    <tr valign="top"><th scope="row"><label for="signoff_text1"><?php _e( 'Signoff Text 1', 'made' ); ?></label></th>
	<td>
	<textarea id="signoff_text1" name="oswc_misc[signoff_text1]" rows="5" cols="75"><?php echo stripslashes($settings['signoff_text1']); ?></textarea><br />
    <?php _e( 'When you use the Signoff1 shortcode this is the text that will display', 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="signoff_text2"><?php _e( 'Signoff Text 2', 'made' ); ?></label></th>
	<td>
	<textarea id="signoff_text2" name="oswc_misc[signoff_text2]" rows="5" cols="75"><?php echo stripslashes($settings['signoff_text2']); ?></textarea><br />
    <?php _e( 'When you use the Signoff2 shortcode this is the text that will display', 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="signoff_text3"><?php _e( 'Signoff Text 3', 'made' ); ?></label></th>
	<td>
	<textarea id="signoff_text3" name="oswc_misc[signoff_text3]" rows="5" cols="75"><?php echo stripslashes($settings['signoff_text3']); ?></textarea><br />
    <?php _e( 'When you use the Signoff3 shortcode this is the text that will display', 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top">
	<td colspan="2">
	<h3><?php _e( 'Social Media', 'made' ); ?></h3>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="twitter_name"><?php _e( 'Twitter Username', 'made' ); ?></label></th>
	<td>
	<input id="twitter_name" name="oswc_misc[twitter_name]" type="text" value="<?php  esc_attr_e($settings['twitter_name']); ?>" />
    <?php _e( 'Your Twitter Username', 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="facebook_url"><?php _e( 'Facebook URL', 'made' ); ?></label></th>
	<td>
	<input id="facebook_url" name="oswc_misc[facebook_url]" type="text" value="<?php  esc_attr_e($settings['facebook_url']); ?>" style="width:500px;" />
    <?php _e( 'Your Facebook URL', 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="flickr_name"><?php _e( 'Flickr Account ID', 'made' ); ?></label></th>
	<td>
	<input id="flickr_name" name="oswc_misc[flickr_name]" type="text" value="<?php  esc_attr_e($settings['flickr_name']); ?>" />
    <?php _e( 'Your Flickr Account ID. Use this service to find it: http://idgettr.com/', 'made' ); ?> 
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="rss_feed"><?php _e( 'RSS Feed URL', 'made' ); ?></label></th>
	<td>
	<input id="rss_feed" name="oswc_misc[rss_feed]" type="text" value="<?php  esc_attr_e($settings['rss_feed']); ?>" style="width:500px;" />
    <?php _e( 'Your RSS Feed URL', 'made' ); ?>
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="feedburner"><?php _e( 'Feedburner Feed Name', 'made' ); ?></label></th>
	<td>
	<input id="feedburner" name="oswc_misc[feedburner]" type="text" value="<?php  esc_attr_e($settings['feedburner']); ?>" style="width:500px;" />&nbsp;&nbsp;
    <a href="http://netprofitstoday.com/blog/how-to-find-your-feedburner-id/" target="_blank"><?php _e( 'How to find your Feed Name','made'); ?></a>&nbsp;&raquo;
	</td>
	</tr>
    
    <tr valign="top"><th scope="row"><label for="google_analytics"><?php _e( 'Google Analytics', 'made' ); ?></label></th>
	<td>
	<textarea id="google_analytics" name="oswc_misc[google_analytics]" rows="15" cols="125"><?php echo stripslashes($settings['google_analytics']); ?></textarea><br />
    <?php _e( 'Copy &amp; paste your Google Analytics code', 'made' ); ?>
	</td>
	</tr>

	</table>

	<p class="submit"><input type="submit" class="button-primary" value="Save Options" /></p>

	</form>

	</div>
    
    <!-- enable color pickers -->
	<script type="text/javascript">
    jQuery(document).ready(function(){
        //colorpickers
        jQuery('#color_scheme').ColorPicker({
            onSubmit: function(hsb, hex, rgb, el) {
                jQuery(el).val(hex);
                jQuery(el).ColorPickerHide();
            },
            onBeforeShow: function () {
                jQuery(this).ColorPickerSetColor(this.value);
            },
            onChange: function (hsb, hex, rgb) {
                jQuery('#color_scheme_preview').css('backgroundColor', '#' + hex);
                jQuery('#color_scheme').val(hex);
            }
        })        
        .bind('keyup', function(){
            jQuery(this).ColorPickerSetColor(this.value);
        });
    });
    </script>

	<?php
}

function oswc_validate_front( $input ) {
	global $oswc_front;

	$settings = get_option( 'oswc_front', $oswc_front );
	
	// We strip all tags from the text field, to avoid vulnerablilties like XSS
	$input['spotlight_tag'] = wp_filter_nohtml_kses( $input['spotlight_tag'] );
	$input['spotlight_header_text'] = wp_filter_post_kses( $input['spotlight_header_text'] );
	$input['spotlight_reactions_text'] = wp_filter_post_kses( $input['spotlight_reactions_text'] );
	
	return $input;
}

function oswc_validate_single( $input ) {
	global $oswc_single;

	$settings = get_option( 'oswc_single', $oswc_single );
	
	// We strip all tags from the text field, to avoid vulnerablilties like XSS
	$input['archive_header_text'] = wp_filter_post_kses( $input['archive_header_text'] );
	$input['category_header_text'] = wp_filter_post_kses( $input['category_header_text'] );	
		
	return $input;
}

function oswc_validate_other( $input ) {
	global $oswc_other;

	$settings = get_option( 'oswc_other', $oswc_other );
	
		
	return $input;
}

function oswc_validate_ads( $input ) {
	global $oswc_ads;

	$settings = get_option( 'oswc_ads', $oswc_ads );
	
	
	return $input;
}

function oswc_validate_bp( $input ) {
	global $oswc_bp;

	$settings = get_option( 'oswc_bp', $oswc_bp );
	
	
	return $input;
}

function oswc_validate_misc( $input ) {
	global $oswc_misc;

	$settings = get_option( 'oswc_misc', $oswc_misc );
		
		
	return $input;
}

endif;  // EndIf is_admin()
?>